/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.task.AgentTask;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.thrift.TTaskType;

public class TaskFailedProcNode
implements ProcNodeInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"TaskSignature").add((Object)"FailedTimes").build();
    private long backendId;
    private TTaskType type;

    public TaskFailedProcNode(long backendId, TTaskType type) {
        this.backendId = backendId;
        this.type = type;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        List<AgentTask> tasks = AgentTaskQueue.getFailedTask(this.backendId, this.type);
        for (AgentTask task : tasks) {
            ArrayList row = Lists.newArrayList();
            row.add(String.valueOf(task.getSignature()));
            row.add(String.valueOf(task.getFailedTimes()));
            result.addRow(row);
        }
        return result;
    }
}

