/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.ReplicasProcNode;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.system.Backend;

public class TabletsProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"TabletId").add((Object)"ReplicaId").add((Object)"BackendId").add((Object)"SchemaHash").add((Object)"Version").add((Object)"LstSuccessVersion").add((Object)"LstFailedVersion").add((Object)"LstFailedTime").add((Object)"DataSize").add((Object)"RowCount").add((Object)"State").add((Object)"LstConsistencyCheckTime").add((Object)"CheckVersion").add((Object)"VersionCount").add((Object)"PathHash").add((Object)"MetaUrl").add((Object)"CompactionStatus").build();
    private Table table;
    private MaterializedIndex index;

    public TabletsProcDir(Table table, MaterializedIndex index) {
        this.table = table;
        this.index = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Comparable>> fetchComparableResult(long version, long backendId, Replica.ReplicaState state) {
        Preconditions.checkNotNull((Object)this.table);
        Preconditions.checkNotNull((Object)this.index);
        ImmutableMap<Long, Backend> backendMap = Catalog.getCurrentSystemInfo().getIdToBackend();
        ArrayList<List<Comparable>> tabletInfos = new ArrayList<List<Comparable>>();
        this.table.readLock();
        try {
            for (Tablet tablet : this.index.getTablets()) {
                long tabletId = tablet.getId();
                if (tablet.getReplicas().size() == 0) {
                    ArrayList<Object> tabletInfo = new ArrayList<Object>();
                    tabletInfo.add(tabletId);
                    tabletInfo.add(-1);
                    tabletInfo.add(-1);
                    tabletInfo.add(-1);
                    tabletInfo.add(FeConstants.null_string);
                    tabletInfo.add(-1);
                    tabletInfo.add(-1);
                    tabletInfo.add(-1);
                    tabletInfo.add(-1);
                    tabletInfo.add(-1);
                    tabletInfo.add(-1);
                    tabletInfo.add(-1);
                    tabletInfo.add(-1);
                    tabletInfo.add(-1);
                    tabletInfo.add(FeConstants.null_string);
                    tabletInfo.add(-1);
                    tabletInfo.add(-1);
                    tabletInfo.add(-1);
                    tabletInfo.add(-1);
                    tabletInfo.add(-1);
                    tabletInfo.add(FeConstants.null_string);
                    tabletInfo.add(FeConstants.null_string);
                    tabletInfos.add(tabletInfo);
                    continue;
                }
                for (Replica replica : tablet.getReplicas()) {
                    if (version > -1L && replica.getVersion() != version || backendId > -1L && replica.getBackendId() != backendId || state != null && replica.getState() != state) continue;
                    ArrayList<Object> tabletInfo = new ArrayList<Object>();
                    tabletInfo.add(tabletId);
                    tabletInfo.add(replica.getId());
                    tabletInfo.add(replica.getBackendId());
                    tabletInfo.add(replica.getSchemaHash());
                    tabletInfo.add(replica.getVersion());
                    tabletInfo.add(replica.getLastSuccessVersion());
                    tabletInfo.add(replica.getLastFailedVersion());
                    tabletInfo.add(TimeUtils.longToTimeString(replica.getLastFailedTimestamp()));
                    tabletInfo.add(replica.getDataSize());
                    tabletInfo.add(replica.getRowCount());
                    tabletInfo.add((Object)replica.getState());
                    tabletInfo.add(TimeUtils.longToTimeString(tablet.getLastCheckTime()));
                    tabletInfo.add(tablet.getCheckedVersion());
                    tabletInfo.add(replica.getVersionCount());
                    tabletInfo.add(replica.getPathHash());
                    String metaUrl = String.format("http://%s:%d/api/meta/header/%d/%d", ((Backend)backendMap.get((Object)replica.getBackendId())).getHost(), ((Backend)backendMap.get((Object)replica.getBackendId())).getHttpPort(), tabletId, replica.getSchemaHash());
                    tabletInfo.add(metaUrl);
                    String compactionUrl = String.format("http://%s:%d/api/compaction/show?tablet_id=%d&schema_hash=%d", ((Backend)backendMap.get((Object)replica.getBackendId())).getHost(), ((Backend)backendMap.get((Object)replica.getBackendId())).getHttpPort(), tabletId, replica.getSchemaHash());
                    tabletInfo.add(compactionUrl);
                    tabletInfos.add(tabletInfo);
                }
            }
        }
        finally {
            this.table.readUnlock();
        }
        return tabletInfos;
    }

    private List<List<Comparable>> fetchComparableResult() {
        return this.fetchComparableResult(-1L, -1L, null);
    }

    @Override
    public ProcResult fetchResult() {
        List<List<Comparable>> tabletInfos = this.fetchComparableResult();
        ListComparator comparator = new ListComparator(0, 1);
        Collections.sort(tabletInfos, comparator);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        for (int i = 0; i < tabletInfos.size(); ++i) {
            List<Comparable> info = tabletInfos.get(i);
            ArrayList<String> row = new ArrayList<String>(info.size());
            for (int j = 0; j < info.size(); ++j) {
                row.add(info.get(j).toString());
            }
            result.addRow(row);
        }
        return result;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String tabletIdStr) throws AnalysisException {
        Preconditions.checkNotNull((Object)this.table);
        Preconditions.checkNotNull((Object)this.index);
        long tabletId = -1L;
        try {
            tabletId = Long.valueOf(tabletIdStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid tablet id format: " + tabletIdStr);
        }
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        List<Replica> replicas = invertedIndex.getReplicasByTabletId(tabletId);
        return new ReplicasProcNode(tabletId, replicas);
    }

    public static int analyzeColumn(String columnName) throws AnalysisException {
        for (String title : TITLE_NAMES) {
            if (!title.equalsIgnoreCase(columnName)) continue;
            return TITLE_NAMES.indexOf((Object)title);
        }
        throw new AnalysisException("Title name[" + columnName + "] does not exist");
    }
}

