/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.TabletInvertedIndex;
import org.apache.doris.clone.TabletScheduler;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.ReplicasProcNode;

public class TabletSchedulerDetailProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"TabletId").add((Object)"Type").add((Object)"Medium").add((Object)"Status").add((Object)"State").add((Object)"OrigPrio").add((Object)"DynmPrio").add((Object)"SrcBe").add((Object)"SrcPath").add((Object)"DestBe").add((Object)"DestPath").add((Object)"Timeout").add((Object)"Create").add((Object)"LstSched").add((Object)"LstVisit").add((Object)"Finished").add((Object)"Rate").add((Object)"FailedSched").add((Object)"FailedRunning").add((Object)"LstAdjPrio").add((Object)"VisibleVer").add((Object)"CmtVer").add((Object)"ErrMsg").build();
    private String type;
    private TabletScheduler tabletScheduler;

    public TabletSchedulerDetailProcDir(String type) {
        this.type = type;
        this.tabletScheduler = Catalog.getCurrentCatalog().getTabletScheduler();
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        List<Object> tabletInfos = Lists.newArrayList();
        if (this.type.equals("pending_tablets")) {
            tabletInfos = this.tabletScheduler.getPendingTabletsInfo(1000);
        } else if (this.type.equals("running_tablets")) {
            tabletInfos = this.tabletScheduler.getRunningTabletsInfo(1000);
        } else if (this.type.equals("history_tablets")) {
            tabletInfos = this.tabletScheduler.getHistoryTabletsInfo(1000);
        } else {
            throw new AnalysisException("invalid type: " + this.type);
        }
        result.setRows(tabletInfos);
        return result;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String tabletIdStr) throws AnalysisException {
        long tabletId = -1L;
        try {
            tabletId = Long.valueOf(tabletIdStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid tablet id format: " + tabletIdStr);
        }
        TabletInvertedIndex invertedIndex = Catalog.getCurrentInvertedIndex();
        List<Replica> replicas = invertedIndex.getReplicasByTabletId(tabletId);
        return new ReplicasProcNode(tabletId, replicas);
    }
}

