/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.ColocateTableIndex;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.Replica;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.clone.TabletSchedCtx;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.Pair;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.IncompleteTabletsProcNode;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.system.SystemInfoService;
import org.apache.doris.task.AgentTask;
import org.apache.doris.task.AgentTaskQueue;
import org.apache.doris.thrift.TTaskType;

public class TabletHealthProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"DbId").add((Object)"DbName").add((Object)"TabletNum").add((Object)"HealthyNum").add((Object)"ReplicaMissingNum").add((Object)"VersionIncompleteNum").add((Object)"ReplicaRelocatingNum").add((Object)"RedundantNum").add((Object)"ReplicaMissingInClusterNum").add((Object)"ReplicaMissingForTagNum").add((Object)"ForceRedundantNum").add((Object)"ColocateMismatchNum").add((Object)"ColocateRedundantNum").add((Object)"NeedFurtherRepairNum").add((Object)"UnrecoverableNum").add((Object)"ReplicaCompactionTooSlowNum").add((Object)"InconsistentNum").add((Object)"OversizeNum").add((Object)"CloningNum").build();
    private Catalog catalog;

    public TabletHealthProcDir(Catalog catalog) {
        Preconditions.checkNotNull((Object)catalog);
        this.catalog = catalog;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String dbIdStr) throws AnalysisException {
        try {
            long dbId = Long.parseLong(dbIdStr);
            return this.catalog.getDb(dbId).map(IncompleteTabletsProcNode::new).orElse(null);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid db id format: " + dbIdStr);
        }
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        List statistics = this.catalog.getDbIds().parallelStream().flatMap(id -> Stream.of(id == 0L ? null : this.catalog.getDbNullable((long)id))).filter(Objects::nonNull).map(DBTabletStatistic::new).sorted(Comparator.comparing(db -> db.db.getFullName())).collect(Collectors.toList());
        ArrayList<List<String>> rows = new ArrayList<List<String>>(statistics.size() + 1);
        for (DBTabletStatistic statistic : statistics) {
            rows.add(statistic.toRow());
        }
        rows.add(statistics.stream().reduce(new DBTabletStatistic(), DBTabletStatistic::reduce).toRow());
        return new BaseProcResult((List<String>)TITLE_NAMES, (List<List<String>>)rows);
    }

    static class DBTabletStatistic {
        boolean summary;
        Database db;
        int dbNum;
        int tabletNum;
        int healthyNum;
        int replicaMissingNum;
        int versionIncompleteNum;
        int replicaRelocatingNum;
        int redundantNum;
        int replicaMissingInClusterNum;
        int replicaMissingForTagNum;
        int forceRedundantNum;
        int colocateMismatchNum;
        int colocateRedundantNum;
        int needFurtherRepairNum;
        int unrecoverableNum;
        int replicaCompactionTooSlowNum;
        int inconsistentNum;
        int oversizeNum;
        int cloningNum;
        Set<Long> replicaMissingTabletIds;
        Set<Long> versionIncompleteTabletIds;
        Set<Long> replicaRelocatingTabletIds;
        Set<Long> redundantTabletIds;
        Set<Long> replicaMissingInClusterTabletIds;
        Set<Long> replicaMissingForTagTabletIds;
        Set<Long> forceRedundantTabletIds;
        Set<Long> colocateMismatchTabletIds;
        Set<Long> colocateRedundantTabletIds;
        Set<Long> needFurtherRepairTabletIds;
        Set<Long> unrecoverableTabletIds;
        Set<Long> replicaCompactionTooSlowTabletIds;
        Set<Long> inconsistentTabletIds;
        Set<Long> oversizeTabletIds;
        Set<Long> cloningTabletIds;

        DBTabletStatistic() {
            this.summary = true;
        }

        DBTabletStatistic(Database db) {
            Preconditions.checkNotNull((Object)db);
            this.summary = false;
            this.db = db;
            this.dbNum = 1;
            this.replicaMissingTabletIds = new HashSet<Long>();
            this.versionIncompleteTabletIds = new HashSet<Long>();
            this.replicaRelocatingTabletIds = new HashSet<Long>();
            this.redundantTabletIds = new HashSet<Long>();
            this.replicaMissingInClusterTabletIds = new HashSet<Long>();
            this.replicaMissingForTagTabletIds = new HashSet<Long>();
            this.forceRedundantTabletIds = new HashSet<Long>();
            this.colocateMismatchTabletIds = new HashSet<Long>();
            this.colocateRedundantTabletIds = new HashSet<Long>();
            this.needFurtherRepairTabletIds = new HashSet<Long>();
            this.unrecoverableTabletIds = new HashSet<Long>();
            this.replicaCompactionTooSlowTabletIds = new HashSet<Long>();
            this.inconsistentTabletIds = new HashSet<Long>();
            this.oversizeTabletIds = new HashSet<Long>();
            this.cloningTabletIds = new HashSet<Long>();
            SystemInfoService infoService = Catalog.getCurrentSystemInfo();
            ColocateTableIndex colocateTableIndex = Catalog.getCurrentColocateIndex();
            List<Long> aliveBeIdsInCluster = infoService.getClusterBackendIds(db.getClusterName(), true);
            this.cloningTabletIds = AgentTaskQueue.getTask(db.getId(), TTaskType.CLONE).stream().map(AgentTask::getTabletId).collect(Collectors.toSet());
            this.cloningNum = this.cloningTabletIds.size();
            db.getTables().stream().filter(t -> t != null && t.getType() == Table.TableType.OLAP).forEach(t -> {
                OlapTable olapTable = (OlapTable)t;
                ColocateTableIndex.GroupId groupId = colocateTableIndex.isColocateTable(olapTable.getId()) ? colocateTableIndex.getGroup(olapTable.getId()) : null;
                olapTable.readLock();
                try {
                    for (Partition partition : olapTable.getAllPartitions()) {
                        ReplicaAllocation replicaAlloc = olapTable.getPartitionInfo().getReplicaAllocation(partition.getId());
                        for (MaterializedIndex materializedIndex : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                            List<Tablet> tablets = materializedIndex.getTablets();
                            block19: for (int i = 0; i < tablets.size(); ++i) {
                                Tablet tablet = tablets.get(i);
                                ++this.tabletNum;
                                Tablet.TabletStatus res = null;
                                if (groupId != null) {
                                    Set<Long> backendsSet = colocateTableIndex.getTabletBackendsByGroup(groupId, i);
                                    res = tablet.getColocateHealthStatus(partition.getVisibleVersion(), replicaAlloc, backendsSet);
                                } else {
                                    Pair<Tablet.TabletStatus, TabletSchedCtx.Priority> pair = tablet.getHealthStatusWithPriority(infoService, db.getClusterName(), partition.getVisibleVersion(), replicaAlloc, aliveBeIdsInCluster);
                                    res = (Tablet.TabletStatus)((Object)((Object)pair.first));
                                }
                                switch (res) {
                                    case HEALTHY: {
                                        ++this.healthyNum;
                                        break;
                                    }
                                    case REPLICA_MISSING: {
                                        ++this.replicaMissingNum;
                                        this.replicaMissingTabletIds.add(tablet.getId());
                                        break;
                                    }
                                    case VERSION_INCOMPLETE: {
                                        ++this.versionIncompleteNum;
                                        this.versionIncompleteTabletIds.add(tablet.getId());
                                        break;
                                    }
                                    case REPLICA_RELOCATING: {
                                        ++this.replicaRelocatingNum;
                                        this.replicaRelocatingTabletIds.add(tablet.getId());
                                        break;
                                    }
                                    case REDUNDANT: {
                                        ++this.redundantNum;
                                        this.redundantTabletIds.add(tablet.getId());
                                        break;
                                    }
                                    case REPLICA_MISSING_IN_CLUSTER: {
                                        ++this.replicaMissingInClusterNum;
                                        this.replicaMissingInClusterTabletIds.add(tablet.getId());
                                        break;
                                    }
                                    case REPLICA_MISSING_FOR_TAG: {
                                        ++this.replicaMissingForTagNum;
                                        this.replicaMissingForTagTabletIds.add(tablet.getId());
                                        break;
                                    }
                                    case FORCE_REDUNDANT: {
                                        ++this.forceRedundantNum;
                                        this.forceRedundantTabletIds.add(tablet.getId());
                                        break;
                                    }
                                    case COLOCATE_MISMATCH: {
                                        ++this.colocateMismatchNum;
                                        this.colocateMismatchTabletIds.add(tablet.getId());
                                        break;
                                    }
                                    case COLOCATE_REDUNDANT: {
                                        ++this.colocateRedundantNum;
                                        this.colocateRedundantTabletIds.add(tablet.getId());
                                        break;
                                    }
                                    case NEED_FURTHER_REPAIR: {
                                        ++this.needFurtherRepairNum;
                                        this.needFurtherRepairTabletIds.add(tablet.getId());
                                        break;
                                    }
                                    case UNRECOVERABLE: {
                                        ++this.unrecoverableNum;
                                        this.unrecoverableTabletIds.add(tablet.getId());
                                        break;
                                    }
                                }
                                if (!tablet.isConsistent()) {
                                    ++this.inconsistentNum;
                                    this.inconsistentTabletIds.add(tablet.getId());
                                }
                                if (tablet.getDataSize(true) > Config.min_bytes_indicate_replica_too_large) {
                                    ++this.oversizeNum;
                                    this.oversizeTabletIds.add(tablet.getId());
                                }
                                for (Replica replica : tablet.getReplicas()) {
                                    if (replica.getVersionCount() <= (long)Config.min_version_count_indicate_replica_compaction_too_slow) continue;
                                    ++this.replicaCompactionTooSlowNum;
                                    this.replicaCompactionTooSlowTabletIds.add(tablet.getId());
                                    continue block19;
                                }
                            }
                        }
                    }
                }
                finally {
                    olapTable.readUnlock();
                }
            });
        }

        DBTabletStatistic reduce(DBTabletStatistic other) {
            if (this.summary) {
                this.dbNum += other.dbNum;
                this.tabletNum += other.tabletNum;
                this.healthyNum += other.healthyNum;
                this.replicaMissingNum += other.replicaMissingNum;
                this.versionIncompleteNum += other.versionIncompleteNum;
                this.replicaRelocatingNum += other.replicaRelocatingNum;
                this.redundantNum += other.redundantNum;
                this.replicaMissingInClusterNum += other.replicaMissingInClusterNum;
                this.replicaMissingForTagNum += other.replicaMissingForTagNum;
                this.forceRedundantNum += other.forceRedundantNum;
                this.colocateMismatchNum += other.colocateMismatchNum;
                this.colocateRedundantNum += other.colocateRedundantNum;
                this.needFurtherRepairNum += other.needFurtherRepairNum;
                this.unrecoverableNum += this.unrecoverableNum;
                this.replicaCompactionTooSlowNum += this.replicaCompactionTooSlowNum;
                this.inconsistentNum += this.inconsistentNum;
                this.oversizeNum += this.oversizeNum;
                this.cloningNum += this.cloningNum;
                return this;
            }
            if (other.summary) {
                return other.reduce(this);
            }
            return new DBTabletStatistic().reduce(this).reduce(other);
        }

        List<String> toRow() {
            ArrayList<Object> row = new ArrayList<Object>(TITLE_NAMES.size());
            if (this.summary) {
                row.add("Total");
                row.add(this.dbNum);
            } else {
                row.add(this.db.getId());
                row.add(this.db.getFullName());
            }
            row.add(this.tabletNum);
            row.add(this.healthyNum);
            row.add(this.replicaMissingNum);
            row.add(this.versionIncompleteNum);
            row.add(this.replicaRelocatingNum);
            row.add(this.redundantNum);
            row.add(this.replicaMissingInClusterNum);
            row.add(this.replicaMissingForTagNum);
            row.add(this.forceRedundantNum);
            row.add(this.colocateMismatchNum);
            row.add(this.colocateRedundantNum);
            row.add(this.needFurtherRepairNum);
            row.add(this.unrecoverableNum);
            row.add(this.replicaCompactionTooSlowNum);
            row.add(this.inconsistentNum);
            row.add(this.oversizeNum);
            row.add(this.cloningNum);
            return row.stream().map(String::valueOf).collect(Collectors.toList());
        }
    }
}

