/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.TableProcDir;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.common.util.TimeUtils;

public class TablesProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"TableId").add((Object)"TableName").add((Object)"IndexNum").add((Object)"PartitionColumnName").add((Object)"PartitionNum").add((Object)"State").add((Object)"Type").add((Object)"LastConsistencyCheckTime").add((Object)"ReplicaCount").build();
    private Database db;

    public TablesProcDir(Database db) {
        this.db = db;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String tableIdStr) throws AnalysisException {
        long tableId;
        Preconditions.checkNotNull((Object)this.db);
        if (Strings.isNullOrEmpty((String)tableIdStr)) {
            throw new AnalysisException("TableIdStr is null");
        }
        try {
            tableId = Long.parseLong(tableIdStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid table id format: " + tableIdStr);
        }
        Table table = this.db.getTableOrAnalysisException(tableId);
        return new TableProcDir(this.db, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.db);
        ArrayList tableInfos = new ArrayList();
        List<Table> tableList = this.db.getTables();
        for (Table table : tableList) {
            ArrayList<Object> tableInfo = new ArrayList<Object>();
            int n = 1;
            long replicaCount = 0L;
            String partitionKey = FeConstants.null_string;
            table.readLock();
            try {
                if (table.getType() == Table.TableType.OLAP) {
                    OlapTable olapTable = (OlapTable)table;
                    if (olapTable.getPartitionInfo().getType() == PartitionType.RANGE) {
                        n = olapTable.getPartitions().size();
                        RangePartitionInfo info = (RangePartitionInfo)olapTable.getPartitionInfo();
                        partitionKey = "";
                        int idx = 0;
                        for (Column column : info.getPartitionColumns()) {
                            if (idx != 0) {
                                partitionKey = partitionKey + ", ";
                            }
                            partitionKey = partitionKey + column.getName();
                            ++idx;
                        }
                    }
                    replicaCount = olapTable.getReplicaCount();
                    tableInfo.add(table.getId());
                    tableInfo.add(table.getName());
                    tableInfo.add(olapTable.getIndexNameToId().size());
                    tableInfo.add(partitionKey);
                    tableInfo.add(n);
                    tableInfo.add((Object)olapTable.getState());
                    tableInfo.add((Object)table.getType());
                } else {
                    tableInfo.add(table.getId());
                    tableInfo.add(table.getName());
                    tableInfo.add(FeConstants.null_string);
                    tableInfo.add(partitionKey);
                    tableInfo.add(n);
                    tableInfo.add(FeConstants.null_string);
                    tableInfo.add((Object)table.getType());
                }
                tableInfo.add(TimeUtils.longToTimeString(table.getLastCheckTime()));
                tableInfo.add(replicaCount);
                tableInfos.add(tableInfo);
            }
            finally {
                table.readUnlock();
            }
        }
        ListComparator comparator = new ListComparator(0);
        Collections.sort(tableInfos, comparator);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        for (List list : tableInfos) {
            ArrayList<String> row = new ArrayList<String>(list.size());
            for (Comparable comparable : list) {
                row.add(comparable.toString());
            }
            result.addRow(row);
        }
        return result;
    }
}

