/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.EsTable;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.EsPartitionsProcDir;
import org.apache.doris.common.proc.IndexInfoProcDir;
import org.apache.doris.common.proc.PartitionsProcDir;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;

public class TableProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"Nodes").build();
    public static final String INDEX_SCHEMA = "index_schema";
    private static final String PARTITIONS = "partitions";
    private static final String TEMP_PARTITIONS = "temp_partitions";
    private static final ImmutableList<String> CHILDREN_NODES = new ImmutableList.Builder().add((Object)"partitions").add((Object)"temp_partitions").add((Object)"index_schema").build();
    private Database db;
    private Table table;

    public TableProcDir(Database db, Table table) {
        this.db = db;
        this.table = table;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        for (String name : CHILDREN_NODES) {
            result.addRow(Lists.newArrayList((Object[])new String[]{name}));
        }
        return result;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String entryName) throws AnalysisException {
        Preconditions.checkNotNull((Object)this.db);
        Preconditions.checkNotNull((Object)this.table);
        if (Strings.isNullOrEmpty((String)entryName)) {
            throw new AnalysisException("Entry name is null");
        }
        if (entryName.equals(PARTITIONS)) {
            if (this.table.getType() == Table.TableType.OLAP) {
                return new PartitionsProcDir(this.db, (OlapTable)this.table, false);
            }
            if (this.table.getType() == Table.TableType.ELASTICSEARCH) {
                return new EsPartitionsProcDir(this.db, (EsTable)this.table);
            }
            throw new AnalysisException("Table[" + this.table.getName() + "] is not a OLAP or ELASTICSEARCH table");
        }
        if (entryName.equals(TEMP_PARTITIONS)) {
            if (this.table.getType() == Table.TableType.OLAP) {
                return new PartitionsProcDir(this.db, (OlapTable)this.table, true);
            }
            throw new AnalysisException("Table[" + this.table.getName() + "] does not have temp partitions");
        }
        if (entryName.equals(INDEX_SCHEMA)) {
            return new IndexInfoProcDir(this.db, this.table);
        }
        throw new AnalysisException("Not implemented yet: " + entryName);
    }
}

