/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.load.StreamLoadRecordMgr;

public class StreamLoadProcNode
implements ProcNodeInterface {
    private static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"Label").add((Object)"DbId").add((Object)"FinishTime").build();

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult baseProcResult = new BaseProcResult();
        baseProcResult.setNames((List<String>)TITLE_NAMES);
        StreamLoadRecordMgr streamLoadRecordMgr = Catalog.getCurrentCatalog().getStreamLoadRecordMgr();
        try {
            List<StreamLoadRecordMgr.StreamLoadItem> streamLoadJobList = streamLoadRecordMgr.getStreamLoadRecords();
            for (StreamLoadRecordMgr.StreamLoadItem streamLoadItem : streamLoadJobList) {
                baseProcResult.addRow(streamLoadItem.getStatistics());
            }
        }
        catch (Exception e) {
            throw new AnalysisException("failed to get all of stream load job");
        }
        return baseProcResult;
    }
}

