/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Tablet;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.system.SystemInfoService;

public class StatisticProcNode
implements ProcNodeInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"DbId").add((Object)"DbName").add((Object)"TableNum").add((Object)"PartitionNum").add((Object)"IndexNum").add((Object)"TabletNum").add((Object)"ReplicaNum").build();
    private Catalog catalog;

    public StatisticProcNode(Catalog catalog) {
        Preconditions.checkNotNull((Object)catalog);
        this.catalog = catalog;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        List statistics = this.catalog.getDbIds().parallelStream().flatMap(id -> Stream.of(id == 0L ? null : this.catalog.getDbNullable((long)id))).filter(Objects::nonNull).map(DBStatistic::new).sorted(Comparator.comparing(db -> db.db.getFullName())).collect(Collectors.toList());
        ArrayList<List<String>> rows = new ArrayList<List<String>>(statistics.size() + 1);
        for (DBStatistic statistic : statistics) {
            rows.add(statistic.toRow());
        }
        rows.add(statistics.stream().reduce(new DBStatistic(), DBStatistic::reduce).toRow());
        return new BaseProcResult((List<String>)TITLE_NAMES, (List<List<String>>)rows);
    }

    static class DBStatistic {
        boolean summary;
        Database db;
        int dbNum;
        int tableNum;
        int partitionNum;
        int indexNum;
        int tabletNum;
        int replicaNum;

        DBStatistic() {
            this.summary = true;
        }

        DBStatistic(Database db) {
            Preconditions.checkNotNull((Object)db);
            this.summary = false;
            this.db = db;
            this.dbNum = 1;
            SystemInfoService infoService = Catalog.getCurrentSystemInfo();
            db.getTables().stream().filter(t -> t != null && t.getType() == Table.TableType.OLAP).forEach(t -> {
                ++this.tableNum;
                OlapTable olapTable = (OlapTable)t;
                olapTable.readLock();
                try {
                    for (Partition partition : olapTable.getAllPartitions()) {
                        ReplicaAllocation replicaAlloc = olapTable.getPartitionInfo().getReplicaAllocation(partition.getId());
                        ++this.partitionNum;
                        for (MaterializedIndex materializedIndex : partition.getMaterializedIndices(MaterializedIndex.IndexExtState.VISIBLE)) {
                            ++this.indexNum;
                            List<Tablet> tablets = materializedIndex.getTablets();
                            for (int i = 0; i < tablets.size(); ++i) {
                                Tablet tablet = tablets.get(i);
                                ++this.tabletNum;
                                this.replicaNum += tablet.getReplicas().size();
                            }
                        }
                    }
                }
                finally {
                    olapTable.readUnlock();
                }
            });
        }

        DBStatistic reduce(DBStatistic other) {
            if (this.summary) {
                this.dbNum += other.dbNum;
                this.tableNum += other.tableNum;
                this.partitionNum += other.partitionNum;
                this.indexNum += other.indexNum;
                this.tabletNum += other.tabletNum;
                this.replicaNum += other.replicaNum;
                return this;
            }
            if (other.summary) {
                return other.reduce(this);
            }
            return new DBStatistic().reduce(this).reduce(other);
        }

        List<String> toRow() {
            ArrayList<Object> row = new ArrayList<Object>(TITLE_NAMES.size());
            if (this.summary) {
                row.add("Total");
                row.add(this.dbNum);
            } else {
                row.add(this.db.getId());
                row.add(this.db.getFullName());
            }
            row.add(this.tableNum);
            row.add(this.partitionNum);
            row.add(this.indexNum);
            row.add(this.tabletNum);
            row.add(this.replicaNum);
            return row.stream().map(String::valueOf).collect(Collectors.toList());
        }
    }
}

