/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.alter.SchemaChangeHandler;
import org.apache.doris.alter.SchemaChangeJobV2;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.SchemaChangeJobProcNode;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.common.util.OrderByPair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SchemaChangeProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"JobId").add((Object)"TableName").add((Object)"CreateTime").add((Object)"FinishTime").add((Object)"IndexName").add((Object)"IndexId").add((Object)"OriginIndexId").add((Object)"SchemaVersion").add((Object)"TransactionId").add((Object)"State").add((Object)"Msg").add((Object)"Progress").add((Object)"Timeout").build();
    private static final Logger LOG = LogManager.getLogger(SchemaChangeProcDir.class);
    private SchemaChangeHandler schemaChangeHandler;
    private Database db;

    public SchemaChangeProcDir(SchemaChangeHandler schemaChangeHandler, Database db) {
        this.schemaChangeHandler = schemaChangeHandler;
        this.db = db;
    }

    boolean filterResult(String columnName, Comparable element, HashMap<String, Expr> filter) throws AnalysisException {
        if (filter == null) {
            return true;
        }
        Expr subExpr = filter.get(columnName.toLowerCase());
        if (subExpr == null) {
            return true;
        }
        BinaryPredicate binaryPredicate = (BinaryPredicate)subExpr;
        if (subExpr.getChild(1) instanceof StringLiteral && binaryPredicate.getOp() == BinaryPredicate.Operator.EQ) {
            return ((StringLiteral)subExpr.getChild(1)).getValue().equals(element);
        }
        if (subExpr.getChild(1) instanceof DateLiteral) {
            Long leftVal = new DateLiteral((String)((Object)element), (Type)Type.DATETIME).getLongValue();
            Long rightVal = ((DateLiteral)subExpr.getChild(1)).getLongValue();
            switch (binaryPredicate.getOp()) {
                case EQ: 
                case EQ_FOR_NULL: {
                    return leftVal.equals(rightVal);
                }
                case GE: {
                    return leftVal >= rightVal;
                }
                case GT: {
                    return leftVal > rightVal;
                }
                case LE: {
                    return leftVal <= rightVal;
                }
                case LT: {
                    return leftVal < rightVal;
                }
                case NE: {
                    return !leftVal.equals(rightVal);
                }
            }
            Preconditions.checkState((boolean)false, (Object)"No defined binary operator.");
        }
        return true;
    }

    public ProcResult fetchResultByFilter(HashMap<String, Expr> filter, ArrayList<OrderByPair> orderByPairs, LimitElement limitElement) throws AnalysisException {
        List<List> jobInfos;
        Preconditions.checkNotNull((Object)this.db);
        Preconditions.checkNotNull((Object)this.schemaChangeHandler);
        ArrayList schemaChangeJobInfos = this.schemaChangeHandler.getAlterJobInfosByDb(this.db);
        if (filter == null || filter.size() == 0) {
            jobInfos = schemaChangeJobInfos;
        } else {
            jobInfos = Lists.newArrayList();
            for (List infoStr : schemaChangeJobInfos) {
                if (infoStr.size() != TITLE_NAMES.size()) {
                    LOG.warn("SchemaChangeJobInfos.size() " + schemaChangeJobInfos.size() + " not equal TITLE_NAMES.size() " + TITLE_NAMES.size());
                    continue;
                }
                boolean isNeed = true;
                for (int i = 0; i < infoStr.size() && (isNeed = this.filterResult((String)TITLE_NAMES.get(i), (Comparable)infoStr.get(i), filter)); ++i) {
                }
                if (!isNeed) continue;
                jobInfos.add(infoStr);
            }
        }
        if (orderByPairs != null) {
            ListComparator comparator = null;
            OrderByPair[] orderByPairArr = new OrderByPair[orderByPairs.size()];
            comparator = new ListComparator(orderByPairs.toArray(orderByPairArr));
            Collections.sort(jobInfos, comparator);
        }
        if (limitElement != null && limitElement.hasLimit()) {
            int beginIndex = (int)limitElement.getOffset();
            int endIndex = (int)((long)beginIndex + limitElement.getLimit());
            if (endIndex > jobInfos.size()) {
                endIndex = jobInfos.size();
            }
            jobInfos = jobInfos.subList(beginIndex, endIndex);
        }
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        for (List jobInfo : jobInfos) {
            ArrayList<String> oneResult = new ArrayList<String>(jobInfos.size());
            for (Comparable column : jobInfo) {
                oneResult.add(column.toString());
            }
            result.addRow(oneResult);
        }
        return result;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.db);
        Preconditions.checkNotNull((Object)this.schemaChangeHandler);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        List<List<Comparable>> schemaChangeJobInfos = this.schemaChangeHandler.getAlterJobInfosByDb(this.db);
        for (List<Comparable> infoStr : schemaChangeJobInfos) {
            ArrayList<String> oneInfo = new ArrayList<String>(TITLE_NAMES.size());
            for (Comparable element : infoStr) {
                oneInfo.add(element.toString());
            }
            result.addRow(oneInfo);
        }
        return result;
    }

    public static int analyzeColumn(String columnName) throws AnalysisException {
        for (int i = 0; i < TITLE_NAMES.size(); ++i) {
            if (!((String)TITLE_NAMES.get(i)).equalsIgnoreCase(columnName)) continue;
            return i;
        }
        throw new AnalysisException("Title name[" + columnName + "] does not exist");
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String jobIdStr) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)jobIdStr)) {
            throw new AnalysisException("Job id is null");
        }
        long jobId = -1L;
        try {
            jobId = Long.valueOf(jobIdStr);
        }
        catch (Exception e) {
            throw new AnalysisException("Job id is invalid");
        }
        Preconditions.checkState((jobId != -1L ? 1 : 0) != 0);
        AlterJobV2 job = this.schemaChangeHandler.getUnfinishedAlterJobV2ByJobId(jobId);
        if (job == null) {
            return null;
        }
        return new SchemaChangeJobProcNode((SchemaChangeJobV2)job);
    }
}

