/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.doris.alter.SchemaChangeJobV2;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;

public class SchemaChangeJobProcNode
implements ProcNodeInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"BackendId").add((Object)"BaseTabletId").add((Object)"RollupTabletId").build();
    private SchemaChangeJobV2 job;

    public SchemaChangeJobProcNode(SchemaChangeJobV2 job) {
        this.job = job;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.job);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        List<List<String>> unfinishedRollupTasks = this.job.getUnfinishedTasks(2000);
        result.setRows(unfinishedRollupTasks);
        return result;
    }
}

