/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.RoutineLoadsNameProcDir;
import org.apache.doris.load.routineload.RoutineLoadJob;
import org.apache.doris.load.routineload.RoutineLoadManager;

public class RoutineLoadsProcDir
implements ProcDirInterface {
    private static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"Name").add((Object)"Id").add((Object)"DbName").add((Object)"Statistic").add((Object)"TaskStatistic").build();

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String jobName) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)jobName)) {
            throw new IllegalArgumentException("job name could not be empty of null");
        }
        return new RoutineLoadsNameProcDir(jobName);
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult baseProcResult = new BaseProcResult();
        baseProcResult.setNames((List<String>)TITLE_NAMES);
        RoutineLoadManager routineLoadManager = Catalog.getCurrentCatalog().getRoutineLoadManager();
        try {
            List<RoutineLoadJob> routineLoadJobList = routineLoadManager.getJob(null, null, true, null);
            for (RoutineLoadJob routineLoadJob : routineLoadJobList) {
                baseProcResult.addRow(routineLoadJob.getShowStatistic());
            }
        }
        catch (MetaNotFoundException e) {
            throw new AnalysisException("failed to get all of routine load job");
        }
        return baseProcResult;
    }
}

