/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.doris.analysis.ShowRoutineLoadStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.RoutineLoadProcNode;
import org.apache.doris.load.routineload.RoutineLoadJob;
import org.apache.doris.load.routineload.RoutineLoadManager;

public class RoutineLoadsNameProcDir
implements ProcDirInterface {
    private final String jobName;

    public RoutineLoadsNameProcDir(String jobName) {
        this.jobName = jobName;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String jobIdStr) throws AnalysisException {
        long jobId;
        Preconditions.checkNotNull((Object)jobIdStr);
        try {
            jobId = Long.valueOf(jobIdStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid job id format: " + jobIdStr);
        }
        return new RoutineLoadProcNode(jobId);
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult baseProcResult = new BaseProcResult();
        baseProcResult.setNames(ShowRoutineLoadStmt.getTitleNames());
        RoutineLoadManager routineLoadManager = Catalog.getCurrentCatalog().getRoutineLoadManager();
        List<RoutineLoadJob> routineLoadJobList = routineLoadManager.getJobByName(this.jobName);
        for (RoutineLoadJob routineLoadJob : routineLoadJobList) {
            baseProcResult.addRow(routineLoadJob.getShowInfo());
        }
        return baseProcResult;
    }
}

