/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import org.apache.doris.analysis.ShowRoutineLoadTaskStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.load.routineload.RoutineLoadJob;
import org.apache.doris.load.routineload.RoutineLoadManager;

public class RoutineLoadProcNode
implements ProcNodeInterface {
    private final long jobId;

    public RoutineLoadProcNode(long jobId) {
        this.jobId = jobId;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        RoutineLoadManager routineLoadManager = Catalog.getCurrentCatalog().getRoutineLoadManager();
        RoutineLoadJob routineLoadJob = routineLoadManager.getJob(this.jobId);
        if (routineLoadJob == null) {
            throw new AnalysisException("Job[" + this.jobId + "] does not exist");
        }
        BaseProcResult result = new BaseProcResult();
        result.setNames(ShowRoutineLoadTaskStmt.getTitleNames());
        result.setRows(routineLoadJob.getTasksShowInfo());
        return result;
    }
}

