/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.alter.MaterializedViewHandler;
import org.apache.doris.alter.RollupJobV2;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.RollupJobProcNode;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.common.util.OrderByPair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RollupProcDir
implements ProcDirInterface {
    private static final Logger LOG = LogManager.getLogger(RollupProcDir.class);
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"JobId").add((Object)"TableName").add((Object)"CreateTime").add((Object)"FinishTime").add((Object)"BaseIndexName").add((Object)"RollupIndexName").add((Object)"RollupId").add((Object)"TransactionId").add((Object)"State").add((Object)"Msg").add((Object)"Progress").add((Object)"Timeout").build();
    private MaterializedViewHandler materializedViewHandler;
    private Database db;

    public RollupProcDir(MaterializedViewHandler materializedViewHandler, Database db) {
        this.materializedViewHandler = materializedViewHandler;
        this.db = db;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.db);
        Preconditions.checkNotNull((Object)this.materializedViewHandler);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        List<List<Comparable>> rollupJobInfos = this.materializedViewHandler.getAlterJobInfosByDb(this.db);
        for (List<Comparable> infoStr : rollupJobInfos) {
            ArrayList<String> oneInfo = new ArrayList<String>(TITLE_NAMES.size());
            for (Comparable element : infoStr) {
                oneInfo.add(element.toString());
            }
            result.addRow(oneInfo);
        }
        return result;
    }

    public ProcResult fetchResultByFilter(HashMap<String, Expr> filter, ArrayList<OrderByPair> orderByPairs, LimitElement limitElement) throws AnalysisException {
        Preconditions.checkNotNull((Object)this.db);
        Preconditions.checkNotNull((Object)this.materializedViewHandler);
        List<List<Comparable>> rollupJobInfos = this.materializedViewHandler.getAlterJobInfosByDb(this.db);
        List<Object> jobInfos = Lists.newArrayList();
        if (filter == null || filter.size() == 0) {
            jobInfos = rollupJobInfos;
        } else {
            jobInfos = Lists.newArrayList();
            for (List<Comparable> infoStr : rollupJobInfos) {
                if (infoStr.size() != TITLE_NAMES.size()) {
                    LOG.warn("RollupJobInfos.size() " + rollupJobInfos.size() + " not equal TITLE_NAMES.size() " + TITLE_NAMES.size());
                    continue;
                }
                boolean bl = true;
                for (int i = 0; i < infoStr.size() && (bl = this.filterResult((String)TITLE_NAMES.get(i), infoStr.get(i), filter)); ++i) {
                }
                if (!bl) continue;
                jobInfos.add(infoStr);
            }
        }
        if (orderByPairs != null) {
            ListComparator comparator = null;
            OrderByPair[] orderByPairArr = new OrderByPair[orderByPairs.size()];
            comparator = new ListComparator(orderByPairs.toArray(orderByPairArr));
            Collections.sort(jobInfos, comparator);
        }
        if (limitElement != null && limitElement.hasLimit()) {
            int beginIndex = (int)limitElement.getOffset();
            int endIndex = (int)((long)beginIndex + limitElement.getLimit());
            if (endIndex > jobInfos.size()) {
                endIndex = jobInfos.size();
            }
            jobInfos = jobInfos.subList(beginIndex, endIndex);
        }
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        for (List list : jobInfos) {
            ArrayList<String> oneResult = new ArrayList<String>(jobInfos.size());
            for (Comparable column : list) {
                oneResult.add(column.toString());
            }
            result.addRow(oneResult);
        }
        return result;
    }

    boolean filterResult(String columnName, Comparable element, HashMap<String, Expr> filter) throws AnalysisException {
        if (filter == null) {
            return true;
        }
        Expr subExpr = filter.get(columnName.toLowerCase());
        if (subExpr == null) {
            return true;
        }
        BinaryPredicate binaryPredicate = (BinaryPredicate)subExpr;
        if (subExpr.getChild(1) instanceof StringLiteral && binaryPredicate.getOp() == BinaryPredicate.Operator.EQ) {
            return ((StringLiteral)subExpr.getChild(1)).getValue().equals(element);
        }
        if (subExpr.getChild(1) instanceof DateLiteral) {
            Long leftVal = new DateLiteral((String)((Object)element), (Type)Type.DATETIME).getLongValue();
            Long rightVal = ((DateLiteral)subExpr.getChild(1)).getLongValue();
            switch (binaryPredicate.getOp()) {
                case EQ: 
                case EQ_FOR_NULL: {
                    return leftVal.equals(rightVal);
                }
                case GE: {
                    return leftVal >= rightVal;
                }
                case GT: {
                    return leftVal > rightVal;
                }
                case LE: {
                    return leftVal <= rightVal;
                }
                case LT: {
                    return leftVal < rightVal;
                }
                case NE: {
                    return !leftVal.equals(rightVal);
                }
            }
            Preconditions.checkState((boolean)false, (Object)"No defined binary operator.");
        }
        return true;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String jobIdStr) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)jobIdStr)) {
            throw new AnalysisException("Job id is null");
        }
        long jobId = -1L;
        try {
            jobId = Long.valueOf(jobIdStr);
        }
        catch (Exception e) {
            throw new AnalysisException("Job id is invalid");
        }
        Preconditions.checkState((jobId != -1L ? 1 : 0) != 0);
        AlterJobV2 job = this.materializedViewHandler.getUnfinishedAlterJobV2ByJobId(jobId);
        if (job == null) {
            return null;
        }
        return new RollupJobProcNode((RollupJobV2)job);
    }
}

