/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.doris.alter.RollupJobV2;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;

public class RollupJobProcNode
implements ProcNodeInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"BackendId").add((Object)"BaseTabletId").add((Object)"RollupTabletId").build();
    private RollupJobV2 rollupJob;

    public RollupJobProcNode(RollupJobV2 rollupJob) {
        this.rollupJob = rollupJob;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.rollupJob);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        List<List<String>> unfinishedRollupTasks = this.rollupJob.getUnfinishedTasks(2000);
        result.setRows(unfinishedRollupTasks);
        return result;
    }
}

