/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Replica;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.system.Backend;

public class ReplicasProcNode
implements ProcNodeInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"ReplicaId").add((Object)"BackendId").add((Object)"Version").add((Object)"LstSuccessVersion").add((Object)"LstFailedVersion").add((Object)"LstFailedTime").add((Object)"SchemaHash").add((Object)"DataSize").add((Object)"RowCount").add((Object)"State").add((Object)"IsBad").add((Object)"VersionCount").add((Object)"PathHash").add((Object)"MetaUrl").add((Object)"CompactionStatus").build();
    private long tabletId;
    private List<Replica> replicas;

    public ReplicasProcNode(long tabletId, List<Replica> replicas) {
        this.tabletId = tabletId;
        this.replicas = replicas;
    }

    @Override
    public ProcResult fetchResult() {
        ImmutableMap<Long, Backend> backendMap = Catalog.getCurrentSystemInfo().getIdToBackend();
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        for (Replica replica : this.replicas) {
            Backend be = (Backend)backendMap.get((Object)replica.getBackendId());
            String host = be == null ? "0.0.0.0" : be.getHost();
            int port = be == null ? 0 : be.getHttpPort();
            String metaUrl = String.format("http://%s:%d/api/meta/header/%d/%d", host, port, this.tabletId, replica.getSchemaHash());
            String compactionUrl = String.format("http://%s:%d/api/compaction/show?tablet_id=%d&schema_hash=%d", host, port, this.tabletId, replica.getSchemaHash());
            result.addRow(Arrays.asList(String.valueOf(replica.getId()), String.valueOf(replica.getBackendId()), String.valueOf(replica.getVersion()), String.valueOf(replica.getLastSuccessVersion()), String.valueOf(replica.getLastFailedVersion()), TimeUtils.longToTimeString(replica.getLastFailedTimestamp()), String.valueOf(replica.getSchemaHash()), String.valueOf(replica.getDataSize()), String.valueOf(replica.getRowCount()), String.valueOf((Object)replica.getState()), String.valueOf(replica.isBad()), String.valueOf(replica.getVersionCount()), String.valueOf(replica.getPathHash()), metaUrl, compactionUrl));
        }
        return result;
    }
}

