/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Strings;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.proc.AuthProcDir;
import org.apache.doris.common.proc.BDBJEProcDir;
import org.apache.doris.common.proc.BackendsProcDir;
import org.apache.doris.common.proc.BaseProcDir;
import org.apache.doris.common.proc.ClusterBalanceProcDir;
import org.apache.doris.common.proc.ClusterHealthProcDir;
import org.apache.doris.common.proc.ColocationGroupProcDir;
import org.apache.doris.common.proc.CurrentQueryBackendInstanceProcDir;
import org.apache.doris.common.proc.CurrentQueryStatementsProcNode;
import org.apache.doris.common.proc.CurrentQueryStatisticsProcDir;
import org.apache.doris.common.proc.DbsProcDir;
import org.apache.doris.common.proc.FrontendsProcNode;
import org.apache.doris.common.proc.JobsDbProcDir;
import org.apache.doris.common.proc.LoadErrorHubProcNode;
import org.apache.doris.common.proc.MonitorProcDir;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.RoutineLoadsProcDir;
import org.apache.doris.common.proc.StatisticProcNode;
import org.apache.doris.common.proc.StreamLoadProcNode;
import org.apache.doris.common.proc.TasksProcDir;
import org.apache.doris.common.proc.TransDbProcDir;
import org.apache.doris.common.proc.TrashProcDir;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ProcService {
    private static final Logger LOG = LogManager.getLogger(ProcService.class);
    private static volatile ProcService INSTANCE;
    private BaseProcDir root = new BaseProcDir();

    private ProcService() {
        this.root.register("auth", new AuthProcDir(Catalog.getCurrentCatalog().getAuth()));
        this.root.register("backends", new BackendsProcDir(Catalog.getCurrentSystemInfo()));
        this.root.register("dbs", new DbsProcDir(Catalog.getCurrentCatalog()));
        this.root.register("jobs", new JobsDbProcDir(Catalog.getCurrentCatalog()));
        this.root.register("statistic", new StatisticProcNode(Catalog.getCurrentCatalog()));
        this.root.register("tasks", new TasksProcDir());
        this.root.register("frontends", new FrontendsProcNode(Catalog.getCurrentCatalog()));
        this.root.register("brokers", Catalog.getCurrentCatalog().getBrokerMgr().getProcNode());
        this.root.register("resources", Catalog.getCurrentCatalog().getResourceMgr().getProcNode());
        this.root.register("load_error_hub", new LoadErrorHubProcNode(Catalog.getCurrentCatalog()));
        this.root.register("transactions", new TransDbProcDir());
        this.root.register("trash", new TrashProcDir());
        this.root.register("monitor", new MonitorProcDir());
        this.root.register("current_queries", new CurrentQueryStatisticsProcDir());
        this.root.register("current_query_stmts", new CurrentQueryStatementsProcNode());
        this.root.register("current_backend_instances", new CurrentQueryBackendInstanceProcDir());
        this.root.register("cluster_balance", new ClusterBalanceProcDir());
        this.root.register("cluster_health", new ClusterHealthProcDir());
        this.root.register("routine_loads", new RoutineLoadsProcDir());
        this.root.register("stream_loads", new StreamLoadProcNode());
        this.root.register("colocation_group", new ColocationGroupProcDir());
        this.root.register("bdbje", new BDBJEProcDir());
    }

    public ProcNodeInterface open(String path) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new AnalysisException("Path is null");
        }
        int last = 0;
        int pos = 0;
        int len = path.length();
        boolean meetRoot = false;
        boolean meetEnd = false;
        ProcNodeInterface curNode = null;
        block4: while (pos < len && !meetEnd) {
            char ch = path.charAt(pos);
            switch (ch) {
                case '/': {
                    if (!meetRoot) {
                        curNode = this.root;
                        meetRoot = true;
                    } else {
                        String name = path.substring(last, pos);
                        if (!(curNode instanceof ProcDirInterface)) {
                            String errMsg = path.substring(0, pos) + " is not a directory";
                            LOG.warn(errMsg);
                            throw new AnalysisException(errMsg);
                        }
                        curNode = ((ProcDirInterface)curNode).lookup(name);
                    }
                    while (pos < len && path.charAt(pos) == '/') {
                        ++pos;
                    }
                    last = pos;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (meetRoot) {
                        meetEnd = true;
                        continue block4;
                    }
                    ++last;
                    ++pos;
                    continue block4;
                }
            }
            if (!meetRoot) {
                String errMsg = "Path(" + path + ") does not start with '/'";
                LOG.warn(errMsg);
                throw new AnalysisException(errMsg);
            }
            ++pos;
        }
        if (pos == last) {
            if (!(curNode instanceof ProcDirInterface)) {
                String errMsg = path + " is not a directory";
                LOG.warn(errMsg);
                throw new AnalysisException(errMsg);
            }
            return curNode;
        }
        if (!(curNode instanceof ProcDirInterface)) {
            String errMsg = path.substring(0, pos) + " is not a directory";
            LOG.warn(errMsg);
            throw new AnalysisException(errMsg);
        }
        if ((curNode = ((ProcDirInterface)curNode).lookup(path.substring(last, pos))) == null) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_WRONG_PROC_PATH, path);
        }
        return curNode;
    }

    public synchronized boolean register(String name, ProcNodeInterface node) {
        if (Strings.isNullOrEmpty((String)name) || node == null) {
            LOG.warn("register proc service invalid input.");
            return false;
        }
        if (this.root.lookup(name) != null) {
            LOG.warn("node(" + name + ") already exists.");
            return false;
        }
        return this.root.register(name, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProcService getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ProcService> clazz = ProcService.class;
        synchronized (ProcService.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ProcService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void destroy() {
        INSTANCE = null;
    }
}

