/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.DataProperty;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.Pair;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.IndicesProcDir;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.common.util.OrderByPair;
import org.apache.doris.common.util.TimeUtils;

public class PartitionsProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"PartitionId").add((Object)"PartitionName").add((Object)"VisibleVersion").add((Object)"VisibleVersionTime").add((Object)"State").add((Object)"PartitionKey").add((Object)"Range").add((Object)"DistributionKey").add((Object)"Buckets").add((Object)"ReplicationNum").add((Object)"StorageMedium").add((Object)"CooldownTime").add((Object)"LastConsistencyCheckTime").add((Object)"DataSize").add((Object)"IsInMemory").add((Object)"ReplicaAllocation").build();
    private Database db;
    private OlapTable olapTable;
    private boolean isTempPartition = false;

    public PartitionsProcDir(Database db, OlapTable olapTable, boolean isTempPartition) {
        this.db = db;
        this.olapTable = olapTable;
        this.isTempPartition = isTempPartition;
    }

    public boolean filter(String columnName, Comparable element, Map<String, Expr> filterMap) throws AnalysisException {
        if (filterMap == null) {
            return true;
        }
        Expr subExpr = filterMap.get(columnName.toLowerCase());
        if (subExpr == null) {
            return true;
        }
        if (subExpr instanceof BinaryPredicate) {
            long rightVal;
            long leftVal;
            BinaryPredicate binaryPredicate = (BinaryPredicate)subExpr;
            if (subExpr.getChild(1) instanceof StringLiteral && binaryPredicate.getOp() == BinaryPredicate.Operator.EQ) {
                return ((StringLiteral)subExpr.getChild(1)).getValue().equals(element);
            }
            if (subExpr.getChild(1) instanceof DateLiteral) {
                leftVal = new DateLiteral((String)((Object)element), (Type)Type.DATETIME).getLongValue();
                rightVal = ((DateLiteral)subExpr.getChild(1)).getLongValue();
            } else {
                leftVal = Long.parseLong(element.toString());
                rightVal = ((IntLiteral)subExpr.getChild(1)).getLongValue();
            }
            switch (binaryPredicate.getOp()) {
                case EQ: 
                case EQ_FOR_NULL: {
                    return leftVal == rightVal;
                }
                case GE: {
                    return leftVal >= rightVal;
                }
                case GT: {
                    return leftVal > rightVal;
                }
                case LE: {
                    return leftVal <= rightVal;
                }
                case LT: {
                    return leftVal < rightVal;
                }
                case NE: {
                    return leftVal != rightVal;
                }
            }
        } else {
            return this.like((String)((Object)element), ((StringLiteral)subExpr.getChild(1)).getValue());
        }
        Preconditions.checkState((boolean)false, (Object)"No defined binary operator.");
        return true;
    }

    public boolean like(String str, String expr) {
        expr = expr.toLowerCase();
        expr = expr.replace(".", "\\.");
        expr = expr.replace("?", ".");
        expr = expr.replace("%", ".*");
        str = str.toLowerCase();
        return str.matches(expr);
    }

    public ProcResult fetchResultByFilter(Map<String, Expr> filterMap, List<OrderByPair> orderByPairs, LimitElement limitElement) throws AnalysisException {
        List<List> filterPartitionInfos;
        ArrayList partitionInfos = this.getPartitionInfos();
        if (filterMap == null || filterMap.isEmpty()) {
            filterPartitionInfos = partitionInfos;
        } else {
            filterPartitionInfos = Lists.newArrayList();
            for (List partitionInfo : partitionInfos) {
                if (partitionInfo.size() != TITLE_NAMES.size()) {
                    throw new AnalysisException("PartitionInfos.size() " + partitionInfos.size() + " not equal TITLE_NAMES.size() " + TITLE_NAMES.size());
                }
                boolean isNeed = true;
                for (int i = 0; i < partitionInfo.size() && (isNeed = this.filter((String)TITLE_NAMES.get(i), (Comparable)partitionInfo.get(i), filterMap)); ++i) {
                }
                if (!isNeed) continue;
                filterPartitionInfos.add(partitionInfo);
            }
        }
        if (orderByPairs != null) {
            OrderByPair[] orderByPairArr = new OrderByPair[orderByPairs.size()];
            ListComparator comparator = new ListComparator(orderByPairs.toArray(orderByPairArr));
            filterPartitionInfos.sort(comparator);
        }
        if (limitElement != null && limitElement.hasLimit()) {
            int beginIndex = (int)limitElement.getOffset();
            int endIndex = (int)((long)beginIndex + limitElement.getLimit());
            if (endIndex > filterPartitionInfos.size()) {
                endIndex = filterPartitionInfos.size();
            }
            filterPartitionInfos = filterPartitionInfos.subList(beginIndex, endIndex);
        }
        return this.getBasicProcResult((List<List<Comparable>>)filterPartitionInfos);
    }

    public BaseProcResult getBasicProcResult(List<List<Comparable>> partitionInfos) {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        for (List<Comparable> info : partitionInfos) {
            ArrayList<String> row = new ArrayList<String>(info.size());
            for (Comparable comparable : info) {
                row.add(comparable.toString());
            }
            result.addRow(row);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<Comparable>> getPartitionInfos() {
        Preconditions.checkNotNull((Object)this.db);
        Preconditions.checkNotNull((Object)this.olapTable);
        Preconditions.checkState((this.olapTable.getType() == Table.TableType.OLAP ? 1 : 0) != 0);
        ArrayList<List<Comparable>> partitionInfos = new ArrayList<List<Comparable>>();
        this.olapTable.readLock();
        try {
            List partitionIds;
            PartitionInfo tblPartitionInfo = this.olapTable.getPartitionInfo();
            if (tblPartitionInfo.getType() == PartitionType.RANGE || tblPartitionInfo.getType() == PartitionType.LIST) {
                partitionIds = tblPartitionInfo.getPartitionItemEntryList(this.isTempPartition, true).stream().map(Map.Entry::getKey).collect(Collectors.toList());
            } else {
                Collection<Partition> partitions = this.isTempPartition ? this.olapTable.getTempPartitions() : this.olapTable.getPartitions();
                partitionIds = partitions.stream().map(Partition::getId).collect(Collectors.toList());
            }
            Joiner joiner = Joiner.on((String)", ");
            for (Long partitionId : partitionIds) {
                Partition partition = this.olapTable.getPartition(partitionId);
                ArrayList<Object> partitionInfo = new ArrayList<Object>();
                String partitionName = partition.getName();
                partitionInfo.add(partitionId);
                partitionInfo.add(partitionName);
                partitionInfo.add(partition.getVisibleVersion());
                partitionInfo.add(TimeUtils.longToTimeString(partition.getVisibleVersionTime()));
                partitionInfo.add((Object)partition.getState());
                if (tblPartitionInfo.getType() == PartitionType.RANGE || tblPartitionInfo.getType() == PartitionType.LIST) {
                    List<Column> partitionColumns = tblPartitionInfo.getPartitionColumns();
                    ArrayList<String> colNames = new ArrayList<String>();
                    for (Column column : partitionColumns) {
                        colNames.add(column.getName());
                    }
                    partitionInfo.add(joiner.join(colNames));
                    partitionInfo.add(tblPartitionInfo.getItem(partitionId).getItems().toString());
                } else {
                    partitionInfo.add("");
                    partitionInfo.add("");
                }
                DistributionInfo distributionInfo = partition.getDistributionInfo();
                if (distributionInfo.getType() == DistributionInfo.DistributionInfoType.HASH) {
                    HashDistributionInfo hashDistributionInfo = (HashDistributionInfo)distributionInfo;
                    List<Column> distributionColumns = hashDistributionInfo.getDistributionColumns();
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < distributionColumns.size(); ++i) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        sb.append(distributionColumns.get(i).getName());
                    }
                    partitionInfo.add(sb.toString());
                } else {
                    partitionInfo.add("RANDOM");
                }
                partitionInfo.add(distributionInfo.getBucketNum());
                partitionInfo.add(tblPartitionInfo.getReplicaAllocation(partitionId).getTotalReplicaNum());
                DataProperty dataProperty = tblPartitionInfo.getDataProperty(partitionId);
                partitionInfo.add(dataProperty.getStorageMedium().name());
                partitionInfo.add(TimeUtils.longToTimeString(dataProperty.getCooldownTimeMs()));
                partitionInfo.add(TimeUtils.longToTimeString(partition.getLastCheckTime()));
                long dataSize = partition.getDataSize();
                Pair<Double, String> sizePair = DebugUtil.getByteUint(dataSize);
                String readableSize = DebugUtil.DECIMAL_FORMAT_SCALE_3.format(sizePair.first) + " " + (String)sizePair.second;
                partitionInfo.add(readableSize);
                partitionInfo.add(tblPartitionInfo.getIsInMemory(partitionId));
                partitionInfo.add(tblPartitionInfo.getReplicaAllocation(partitionId).toCreateStmt());
                partitionInfos.add(partitionInfo);
            }
        }
        finally {
            this.olapTable.readUnlock();
        }
        return partitionInfos;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        List<List<Comparable>> partitionInfos = this.getPartitionInfos();
        return this.getBasicProcResult(partitionInfos);
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcNodeInterface lookup(String partitionIdStr) throws AnalysisException {
        long partitionId = -1L;
        try {
            partitionId = Long.valueOf(partitionIdStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid partition id format: " + partitionIdStr);
        }
        this.olapTable.readLock();
        try {
            Partition partition = this.olapTable.getPartition(partitionId);
            if (partition == null) {
                throw new AnalysisException("Partition[" + partitionId + "] does not exist");
            }
            IndicesProcDir indicesProcDir = new IndicesProcDir(this.db, this.olapTable, partition);
            return indicesProcDir;
        }
        finally {
            this.olapTable.readUnlock();
        }
    }

    public static int analyzeColumn(String columnName) throws AnalysisException {
        for (int i = 0; i < TITLE_NAMES.size(); ++i) {
            if (!((String)TITLE_NAMES.get(i)).equalsIgnoreCase(columnName)) continue;
            return i;
        }
        ErrorReport.reportAnalysisException(ErrorCode.ERR_WRONG_COLUMN_NAME, columnName);
        return -1;
    }
}

