/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.LoadJobProcNode;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.load.Load;

public class LoadProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"JobId").add((Object)"Label").add((Object)"State").add((Object)"Progress").add((Object)"Type").add((Object)"EtlInfo").add((Object)"TaskInfo").add((Object)"ErrorMsg").add((Object)"CreateTime").add((Object)"EtlStartTime").add((Object)"EtlFinishTime").add((Object)"LoadStartTime").add((Object)"LoadFinishTime").add((Object)"URL").add((Object)"JobDetails").add((Object)"TransactionId").add((Object)"ErrorTablets").build();
    public static final int LABEL_INDEX = 1;
    public static final int STATE_INDEX = 2;
    public static final int ERR_MSG_INDEX = 7;
    public static final int URL_INDEX = 13;
    public static final int JOB_DETAILS_INDEX = 14;
    private static final int LIMIT = 2000;
    private Load load;
    private Database db;

    public LoadProcDir(Load load, Database db) {
        this.load = load;
        this.db = db;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.db);
        Preconditions.checkNotNull((Object)this.load);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        LinkedList<List<Comparable>> loadJobInfos = this.load.getLoadJobInfosByDb(this.db.getId(), this.db.getFullName(), null, false, null);
        loadJobInfos.addAll(Catalog.getCurrentCatalog().getLoadManager().getLoadJobInfosByDb(this.db.getId(), null, false, null));
        int counter = 0;
        Iterator<List<Comparable>> iterator = loadJobInfos.descendingIterator();
        while (iterator.hasNext()) {
            List<Comparable> infoStr = iterator.next();
            ArrayList<String> oneInfo = new ArrayList<String>(TITLE_NAMES.size());
            for (Comparable element : infoStr) {
                oneInfo.add(element.toString());
            }
            result.addRow(oneInfo);
            if (++counter < 2000) continue;
            break;
        }
        return result;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String jobIdStr) throws AnalysisException {
        long jobId = -1L;
        try {
            jobId = Long.valueOf(jobIdStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid job id format: " + jobIdStr);
        }
        return new LoadJobProcNode(this.load, jobId);
    }

    public static int analyzeColumn(String columnName) throws AnalysisException {
        for (String title : TITLE_NAMES) {
            if (!title.equalsIgnoreCase(columnName)) continue;
            return TITLE_NAMES.indexOf((Object)title);
        }
        throw new AnalysisException("Title name[" + columnName + "] does not exist");
    }
}

