/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.monitor.jvm.JvmInfo;
import org.apache.doris.monitor.jvm.JvmService;
import org.apache.doris.monitor.jvm.JvmStats;

public class JvmProcDir
implements ProcNodeInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"Name").add((Object)"Value").build();

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        JvmService jvmService = new JvmService();
        JvmInfo jvmInfo = jvmService.info();
        result.addRow(this.genRow("jvm start time", TimeUtils.longToTimeString(jvmInfo.getStartTime())));
        result.addRow(this.genRow("jvm version info", Joiner.on((String)" ").join((Object)jvmInfo.getVersion(), (Object)jvmInfo.getVmName(), new Object[]{jvmInfo.getVmVendor(), jvmInfo.getVmVersion()})));
        result.addRow(this.genRow("configured init heap size", DebugUtil.printByteWithUnit(jvmInfo.getConfiguredInitialHeapSize())));
        result.addRow(this.genRow("configured max heap size", DebugUtil.printByteWithUnit(jvmInfo.getConfiguredMaxHeapSize())));
        result.addRow(this.genRow("frontend pid", jvmInfo.getPid()));
        JvmStats jvmStats = jvmService.stats();
        result.addRow(this.genRow("classes loaded", jvmStats.getClasses().getLoadedClassCount()));
        result.addRow(this.genRow("classes total loaded", jvmStats.getClasses().getTotalLoadedClassCount()));
        result.addRow(this.genRow("classes unloaded", jvmStats.getClasses().getUnloadedClassCount()));
        result.addRow(this.genRow("mem heap committed", DebugUtil.printByteWithUnit(jvmStats.getMem().getHeapCommitted().getBytes())));
        result.addRow(this.genRow("mem heap used", DebugUtil.printByteWithUnit(jvmStats.getMem().getHeapUsed().getBytes())));
        result.addRow(this.genRow("mem non heap committed", DebugUtil.printByteWithUnit(jvmStats.getMem().getNonHeapCommitted().getBytes())));
        result.addRow(this.genRow("mem non heap used", DebugUtil.printByteWithUnit(jvmStats.getMem().getNonHeapUsed().getBytes())));
        for (Object memPool : jvmStats.getMem()) {
            result.addRow(this.genRow("mem pool " + ((JvmStats.MemoryPool)memPool).getName() + " used", DebugUtil.printByteWithUnit(((JvmStats.MemoryPool)memPool).getUsed().getBytes())));
            result.addRow(this.genRow("mem pool " + ((JvmStats.MemoryPool)memPool).getName() + " max", DebugUtil.printByteWithUnit(((JvmStats.MemoryPool)memPool).getMax().getBytes())));
            result.addRow(this.genRow("mem pool " + ((JvmStats.MemoryPool)memPool).getName() + " peak used", DebugUtil.printByteWithUnit(((JvmStats.MemoryPool)memPool).getPeakUsed().getBytes())));
            result.addRow(this.genRow("mem pool " + ((JvmStats.MemoryPool)memPool).getName() + " peak max", DebugUtil.printByteWithUnit(((JvmStats.MemoryPool)memPool).getPeakMax().getBytes())));
        }
        for (JvmStats.BufferPool bp : jvmStats.getBufferPools()) {
            result.addRow(this.genRow("buffer pool " + bp.getName() + " count", bp.getCount()));
            result.addRow(this.genRow("buffer pool " + bp.getName() + " used", DebugUtil.printByteWithUnit(bp.getUsed().getBytes())));
            result.addRow(this.genRow("buffer pool " + bp.getName() + " capacity", DebugUtil.printByteWithUnit(bp.getTotalCapacity().getBytes())));
        }
        for (JvmStats.GarbageCollector gc : jvmStats.getGc()) {
            result.addRow(this.genRow("gc " + gc.getName() + " collection count", gc.getCollectionCount()));
            result.addRow(this.genRow("gc " + gc.getName() + " collection time", gc.getCollectionTime().getMillis()));
        }
        JvmStats.Threads threads = jvmStats.getThreads();
        result.addRow(this.genRow("threads count", threads.getCount()));
        result.addRow(this.genRow("threads peak count", threads.getPeakCount()));
        result.addRow(this.genRow("threads new count", threads.getThreadsNewCount()));
        result.addRow(this.genRow("threads runnable count", threads.getThreadsRunnableCount()));
        result.addRow(this.genRow("threads blocked count", threads.getThreadsBlockedCount()));
        result.addRow(this.genRow("threads waiting count", threads.getThreadsWaitingCount()));
        result.addRow(this.genRow("threads timed_waiting count", threads.getThreadsTimedWaitingCount()));
        result.addRow(this.genRow("threads terminated count", threads.getThreadsTerminatedCount()));
        return result;
    }

    private List<String> genRow(String key, Object value) {
        ArrayList row = Lists.newArrayList();
        row.add(key);
        row.add(String.valueOf(value));
        return row;
    }
}

