/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.alter.MaterializedViewHandler;
import org.apache.doris.alter.SchemaChangeHandler;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.DeleteInfoProcDir;
import org.apache.doris.common.proc.ExportProcNode;
import org.apache.doris.common.proc.LoadProcDir;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.RollupProcDir;
import org.apache.doris.common.proc.SchemaChangeProcDir;
import org.apache.doris.load.ExportJob;
import org.apache.doris.load.ExportMgr;
import org.apache.doris.load.Load;
import org.apache.doris.load.LoadJob;
import org.apache.doris.load.loadv2.JobState;
import org.apache.doris.load.loadv2.LoadManager;

public class JobsProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"JobType").add((Object)"Pending").add((Object)"Running").add((Object)"Finished").add((Object)"Cancelled").add((Object)"Total").build();
    private static final String LOAD = "load";
    private static final String DELETE = "delete";
    private static final String ROLLUP = "rollup";
    private static final String SCHEMA_CHANGE = "schema_change";
    private static final String EXPORT = "export";
    private Catalog catalog;
    private Database db;

    public JobsProcDir(Catalog catalog, Database db) {
        this.catalog = catalog;
        this.db = db;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String jobTypeName) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)jobTypeName) || this.catalog == null) {
            throw new AnalysisException("Job type name is null");
        }
        if (jobTypeName.equals(LOAD)) {
            return new LoadProcDir(this.catalog.getLoadInstance(), this.db);
        }
        if (jobTypeName.equals(DELETE)) {
            return new DeleteInfoProcDir(this.catalog.getDeleteHandler(), this.catalog.getLoadInstance(), this.db.getId());
        }
        if (jobTypeName.equals(ROLLUP)) {
            return new RollupProcDir(this.catalog.getMaterializedViewHandler(), this.db);
        }
        if (jobTypeName.equals(SCHEMA_CHANGE)) {
            return new SchemaChangeProcDir(this.catalog.getSchemaChangeHandler(), this.db);
        }
        if (jobTypeName.equals(EXPORT)) {
            return new ExportProcNode(this.catalog.getExportMgr(), this.db);
        }
        throw new AnalysisException("Invalid job type: " + jobTypeName);
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.catalog);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        long dbId = this.db.getId();
        Load load = Catalog.getCurrentCatalog().getLoadInstance();
        LoadManager loadManager = Catalog.getCurrentCatalog().getLoadManager();
        Long pendingNum = load.getLoadJobNum(LoadJob.JobState.PENDING, dbId) + (long)loadManager.getLoadJobNum(JobState.PENDING, dbId);
        Long runningNum = load.getLoadJobNum(LoadJob.JobState.ETL, dbId) + load.getLoadJobNum(LoadJob.JobState.LOADING, dbId) + (long)loadManager.getLoadJobNum(JobState.LOADING, dbId);
        Long finishedNum = load.getLoadJobNum(LoadJob.JobState.QUORUM_FINISHED, dbId) + load.getLoadJobNum(LoadJob.JobState.FINISHED, dbId) + (long)loadManager.getLoadJobNum(JobState.FINISHED, dbId);
        Long cancelledNum = load.getLoadJobNum(LoadJob.JobState.CANCELLED, dbId) + (long)loadManager.getLoadJobNum(JobState.CANCELLED, dbId);
        Long totalNum = pendingNum + runningNum + finishedNum + cancelledNum;
        result.addRow(Lists.newArrayList((Object[])new String[]{LOAD, pendingNum.toString(), runningNum.toString(), finishedNum.toString(), cancelledNum.toString(), totalNum.toString()}));
        pendingNum = 0L;
        runningNum = 0L;
        finishedNum = 0L;
        cancelledNum = 0L;
        totalNum = pendingNum + runningNum + finishedNum + cancelledNum;
        result.addRow(Lists.newArrayList((Object[])new String[]{DELETE, pendingNum.toString(), runningNum.toString(), finishedNum.toString(), cancelledNum.toString(), totalNum.toString()}));
        MaterializedViewHandler materializedViewHandler = Catalog.getCurrentCatalog().getMaterializedViewHandler();
        pendingNum = materializedViewHandler.getAlterJobV2Num(AlterJobV2.JobState.PENDING, dbId);
        runningNum = materializedViewHandler.getAlterJobV2Num(AlterJobV2.JobState.WAITING_TXN, dbId) + materializedViewHandler.getAlterJobV2Num(AlterJobV2.JobState.RUNNING, dbId);
        finishedNum = materializedViewHandler.getAlterJobV2Num(AlterJobV2.JobState.FINISHED, dbId);
        cancelledNum = materializedViewHandler.getAlterJobV2Num(AlterJobV2.JobState.CANCELLED, dbId);
        totalNum = pendingNum + runningNum + finishedNum + cancelledNum;
        result.addRow(Lists.newArrayList((Object[])new String[]{ROLLUP, pendingNum.toString(), runningNum.toString(), finishedNum.toString(), cancelledNum.toString(), totalNum.toString()}));
        SchemaChangeHandler schemaChangeHandler = Catalog.getCurrentCatalog().getSchemaChangeHandler();
        pendingNum = schemaChangeHandler.getAlterJobV2Num(AlterJobV2.JobState.PENDING, dbId);
        runningNum = schemaChangeHandler.getAlterJobV2Num(AlterJobV2.JobState.WAITING_TXN, dbId) + schemaChangeHandler.getAlterJobV2Num(AlterJobV2.JobState.RUNNING, dbId);
        finishedNum = schemaChangeHandler.getAlterJobV2Num(AlterJobV2.JobState.FINISHED, dbId);
        cancelledNum = schemaChangeHandler.getAlterJobV2Num(AlterJobV2.JobState.CANCELLED, dbId);
        totalNum = pendingNum + runningNum + finishedNum + cancelledNum;
        result.addRow(Lists.newArrayList((Object[])new String[]{SCHEMA_CHANGE, pendingNum.toString(), runningNum.toString(), finishedNum.toString(), cancelledNum.toString(), totalNum.toString()}));
        ExportMgr exportMgr = Catalog.getCurrentCatalog().getExportMgr();
        pendingNum = exportMgr.getJobNum(ExportJob.JobState.PENDING, dbId);
        runningNum = exportMgr.getJobNum(ExportJob.JobState.EXPORTING, dbId);
        finishedNum = exportMgr.getJobNum(ExportJob.JobState.FINISHED, dbId);
        cancelledNum = exportMgr.getJobNum(ExportJob.JobState.CANCELLED, dbId);
        totalNum = pendingNum + runningNum + finishedNum + cancelledNum;
        result.addRow(Lists.newArrayList((Object[])new String[]{EXPORT, pendingNum.toString(), runningNum.toString(), finishedNum.toString(), cancelledNum.toString(), totalNum.toString()}));
        return result;
    }
}

