/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.JobsProcDir;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;

public class JobsDbProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"DbId").add((Object)"DbName").build();
    private Catalog catalog;

    public JobsDbProcDir(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String dbIdStr) throws AnalysisException {
        long dbId;
        if (Strings.isNullOrEmpty((String)dbIdStr)) {
            throw new AnalysisException("Db id is null");
        }
        try {
            dbId = Long.valueOf(dbIdStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid db id format: " + dbIdStr);
        }
        Database db = this.catalog.getDbOrAnalysisException(dbId);
        return new JobsProcDir(this.catalog, db);
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.catalog);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        List<String> names = this.catalog.getDbNames();
        if (names == null || names.isEmpty()) {
            return result;
        }
        for (String name : names) {
            this.catalog.getDb(name).ifPresent(db -> result.addRow(Lists.newArrayList((Object[])new String[]{String.valueOf(db.getId()), name})));
        }
        return result;
    }
}

