/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndex;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Partition;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.TabletsProcDir;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.common.util.TimeUtils;

public class IndicesProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"IndexId").add((Object)"IndexName").add((Object)"State").add((Object)"LastConsistencyCheckTime").build();
    private Database db;
    private OlapTable olapTable;
    private Partition partition;

    public IndicesProcDir(Database db, OlapTable olapTable, Partition partition) {
        this.db = db;
        this.olapTable = olapTable;
        this.partition = partition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.db);
        Preconditions.checkNotNull((Object)this.partition);
        BaseProcResult result = new BaseProcResult();
        ArrayList indexInfos = new ArrayList();
        this.olapTable.readLock();
        try {
            result.setNames((List<String>)TITLE_NAMES);
            for (MaterializedIndex materializedIndex : this.partition.getMaterializedIndices(MaterializedIndex.IndexExtState.ALL)) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(materializedIndex.getId());
                arrayList.add(this.olapTable.getIndexNameById(materializedIndex.getId()));
                arrayList.add((Object)materializedIndex.getState());
                arrayList.add(TimeUtils.longToTimeString(materializedIndex.getLastCheckTime()));
                indexInfos.add(arrayList);
            }
        }
        finally {
            this.olapTable.readUnlock();
        }
        ListComparator comparator = new ListComparator(0);
        Collections.sort(indexInfos, comparator);
        for (List list : indexInfos) {
            ArrayList<String> row = new ArrayList<String>(list.size());
            for (Comparable comparable : list) {
                row.add(comparable.toString());
            }
            result.addRow(row);
        }
        return result;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcNodeInterface lookup(String indexIdStr) throws AnalysisException {
        long indexId;
        Preconditions.checkNotNull((Object)this.db);
        Preconditions.checkNotNull((Object)this.partition);
        if (Strings.isNullOrEmpty((String)indexIdStr)) {
            throw new AnalysisException("Index id is null");
        }
        try {
            indexId = Long.valueOf(indexIdStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid index id format: " + indexIdStr);
        }
        this.olapTable.readLock();
        try {
            MaterializedIndex materializedIndex = this.partition.getIndex(indexId);
            if (materializedIndex == null) {
                throw new AnalysisException("Index[" + indexId + "] does not exist.");
            }
            TabletsProcDir tabletsProcDir = new TabletsProcDir(this.olapTable, materializedIndex);
            return tabletsProcDir;
        }
        finally {
            this.olapTable.readUnlock();
        }
    }
}

