/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.catalog.Column;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;

public class IndexSchemaProcNode
implements ProcNodeInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"Field").add((Object)"Type").add((Object)"Null").add((Object)"Key").add((Object)"Default").add((Object)"Extra").build();
    private final List<Column> schema;
    private final Set<String> bfColumns;

    public IndexSchemaProcNode(List<Column> schema, Set<String> bfColumns) {
        this.schema = schema;
        this.bfColumns = bfColumns;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull(this.schema);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        for (Column column : this.schema) {
            ArrayList extras = Lists.newArrayList();
            if (column.getAggregationType() != null) {
                extras.add(column.getAggregationType().name());
            }
            if (this.bfColumns != null && this.bfColumns.contains(column.getName())) {
                extras.add("BLOOM_FILTER");
            }
            String extraStr = StringUtils.join((Collection)extras, (String)",");
            List<String> rowList = Arrays.asList(column.getDisplayName(), column.getOriginType().toString(), column.isAllowNull() ? "Yes" : "No", Boolean.valueOf(column.isKey()).toString(), column.getDefaultValue() == null ? FeConstants.null_string : column.getDefaultValue(), extraStr);
            result.addRow(rowList);
        }
        return result;
    }
}

