/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.MaterializedIndexMeta;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.IndexSchemaProcNode;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;

public class IndexInfoProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"IndexId").add((Object)"IndexName").add((Object)"SchemaVersion").add((Object)"SchemaHash").add((Object)"ShortKeyColumnCount").add((Object)"StorageType").add((Object)"Keys").build();
    private Database db;
    private Table table;

    public IndexInfoProcDir(Database db, Table table) {
        this.db = db;
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.db);
        Preconditions.checkNotNull((Object)this.table);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        this.table.readLock();
        try {
            if (this.table.getType() == Table.TableType.OLAP) {
                OlapTable olapTable = (OlapTable)this.table;
                ArrayList indices = Lists.newArrayList();
                indices.add(olapTable.getBaseIndexId());
                indices.addAll(olapTable.getIndexIdListExceptBaseIndex());
                Iterator iterator = indices.iterator();
                while (iterator.hasNext()) {
                    long indexId = (Long)iterator.next();
                    MaterializedIndexMeta indexMeta = olapTable.getIndexIdToMeta().get(indexId);
                    String type = olapTable.getKeysType().name();
                    StringBuilder builder = new StringBuilder();
                    builder.append(type).append("(");
                    ArrayList columnNames = Lists.newArrayList();
                    List<Column> columns = olapTable.getSchemaByIndexId(indexId);
                    for (Column column : columns) {
                        if (!column.isKey()) continue;
                        columnNames.add(column.getName());
                    }
                    builder.append(Joiner.on((String)", ").join((Iterable)columnNames)).append(")");
                    result.addRow(Lists.newArrayList((Object[])new String[]{String.valueOf(indexId), olapTable.getIndexNameById(indexId), String.valueOf(indexMeta.getSchemaVersion()), String.valueOf(indexMeta.getSchemaHash()), String.valueOf(indexMeta.getShortKeyColumnCount()), indexMeta.getStorageType().name(), builder.toString()}));
                }
            } else {
                result.addRow(Lists.newArrayList((Object[])new String[]{"-1", this.table.getName(), "", "", "", "", ""}));
            }
            BaseProcResult baseProcResult = result;
            return baseProcResult;
        }
        finally {
            this.table.readUnlock();
        }
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcNodeInterface lookup(String idxIdStr) throws AnalysisException {
        long idxId;
        Preconditions.checkNotNull((Object)this.db);
        Preconditions.checkNotNull((Object)this.table);
        try {
            idxId = Long.valueOf(idxIdStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid index id format: " + idxIdStr);
        }
        this.table.readLock();
        try {
            List<Column> schema = null;
            Set<String> bfColumns = null;
            if (this.table.getType() == Table.TableType.OLAP) {
                OlapTable olapTable = (OlapTable)this.table;
                schema = olapTable.getSchemaByIndexId(idxId);
                if (schema == null) {
                    throw new AnalysisException("Index " + idxId + " does not exist");
                }
                bfColumns = olapTable.getCopiedBfColumns();
            } else {
                schema = this.table.getBaseSchema();
            }
            IndexSchemaProcNode indexSchemaProcNode = new IndexSchemaProcNode(schema, bfColumns);
            return indexSchemaProcNode;
        }
        finally {
            this.table.readUnlock();
        }
    }
}

