/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.TabletHealthProcDir;

public class IncompleteTabletsProcNode
implements ProcNodeInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"ReplicaMissingTablets").add((Object)"VersionIncompleteTablets").add((Object)"ReplicaRelocatingTablets").add((Object)"RedundantTablets").add((Object)"ReplicaMissingInClusterTablets").add((Object)"ReplicaMissingForTagTablets").add((Object)"ForceRedundantTablets").add((Object)"ColocateMismatchTablets").add((Object)"ColocateRedundantTablets").add((Object)"NeedFurtherRepairTablets").add((Object)"UnrecoverableTablets").add((Object)"ReplicaCompactionTooSlowTablets").add((Object)"InconsistentTablets").add((Object)"OversizeTablets").build();
    private static final Joiner JOINER = Joiner.on((String)",");
    final Database db;

    public IncompleteTabletsProcNode(Database db) {
        this.db = db;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        TabletHealthProcDir.DBTabletStatistic statistic = new TabletHealthProcDir.DBTabletStatistic(this.db);
        return new BaseProcResult((List<String>)TITLE_NAMES, Collections.singletonList(Arrays.asList(JOINER.join(statistic.replicaMissingTabletIds), JOINER.join(statistic.versionIncompleteTabletIds), JOINER.join(statistic.replicaRelocatingTabletIds), JOINER.join(statistic.redundantTabletIds), JOINER.join(statistic.replicaMissingInClusterTabletIds), JOINER.join(statistic.replicaMissingForTagTabletIds), JOINER.join(statistic.forceRedundantTabletIds), JOINER.join(statistic.colocateMismatchTabletIds), JOINER.join(statistic.colocateRedundantTabletIds), JOINER.join(statistic.needFurtherRepairTabletIds), JOINER.join(statistic.unrecoverableTabletIds), JOINER.join(statistic.replicaCompactionTooSlowTabletIds), JOINER.join(statistic.inconsistentTabletIds), JOINER.join(statistic.oversizeTabletIds))));
    }
}

