/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.Config;
import org.apache.doris.common.Pair;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.util.NetUtils;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.system.Frontend;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FrontendsProcNode
implements ProcNodeInterface {
    private static final Logger LOG = LogManager.getLogger(FrontendsProcNode.class);
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"Name").add((Object)"IP").add((Object)"HostName").add((Object)"EditLogPort").add((Object)"HttpPort").add((Object)"QueryPort").add((Object)"RpcPort").add((Object)"Role").add((Object)"IsMaster").add((Object)"ClusterId").add((Object)"Join").add((Object)"Alive").add((Object)"ReplayedJournalId").add((Object)"LastHeartbeat").add((Object)"IsHelper").add((Object)"ErrMsg").add((Object)"Version").add((Object)"CurrentConnected").build();
    public static final int HOSTNAME_INDEX = 2;
    private Catalog catalog;

    public FrontendsProcNode(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public ProcResult fetchResult() {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        ArrayList infos = Lists.newArrayList();
        FrontendsProcNode.getFrontendsInfo(this.catalog, infos);
        for (List info : infos) {
            result.addRow(info);
        }
        return result;
    }

    public static void getFrontendsInfo(Catalog catalog, List<List<String>> infos) {
        String masterIp = "";
        int masterPort = -1;
        try {
            InetSocketAddress master = catalog.getHaProtocol().getLeader();
            masterIp = master.getAddress().getHostAddress();
            masterPort = master.getPort();
        }
        catch (Exception e) {
            LOG.warn("failed to get leader: {}", (Object)e.getMessage());
        }
        List<InetSocketAddress> allFe = catalog.getHaProtocol().getElectableNodes(true);
        allFe.addAll(catalog.getHaProtocol().getObserverNodes());
        List<Pair<String, Integer>> allFeHosts = FrontendsProcNode.convertToHostPortPair(allFe);
        List<Pair<String, Integer>> helperNodes = catalog.getHelperNodes();
        String selfNode = (String)Catalog.getCurrentCatalog().getSelfNode().first;
        if (ConnectContext.get() != null && !Strings.isNullOrEmpty((String)ConnectContext.get().getCurrentConnectedFEIp())) {
            selfNode = ConnectContext.get().getCurrentConnectedFEIp();
        }
        for (Frontend fe : catalog.getFrontends(null)) {
            ArrayList<String> info = new ArrayList<String>();
            info.add(fe.getNodeName());
            info.add(fe.getHost());
            info.add(NetUtils.getHostnameByIp(fe.getHost()));
            info.add(Integer.toString(fe.getEditLogPort()));
            info.add(Integer.toString(Config.http_port));
            if (fe.getHost().equals(catalog.getSelfNode().first)) {
                info.add(Integer.toString(Config.query_port));
                info.add(Integer.toString(Config.rpc_port));
            } else {
                info.add(Integer.toString(fe.getQueryPort()));
                info.add(Integer.toString(fe.getRpcPort()));
            }
            info.add(fe.getRole().name());
            info.add(String.valueOf(fe.getHost().equals(masterIp) && fe.getEditLogPort() == masterPort));
            info.add(Integer.toString(catalog.getClusterId()));
            info.add(String.valueOf(FrontendsProcNode.isJoin(allFeHosts, fe)));
            if (fe.getHost().equals(catalog.getSelfNode().first)) {
                info.add("true");
                info.add(Long.toString(catalog.getEditLog().getMaxJournalId()));
            } else {
                info.add(String.valueOf(fe.isAlive()));
                info.add(Long.toString(fe.getReplayedJournalId()));
            }
            info.add(TimeUtils.longToTimeString(fe.getLastUpdateTime()));
            info.add(String.valueOf(FrontendsProcNode.isHelperNode(helperNodes, fe)));
            info.add(fe.getHeartbeatErrMsg());
            info.add(fe.getVersion());
            info.add(fe.getHost().equals(selfNode) ? "Yes" : "No");
            infos.add(info);
        }
    }

    private static boolean isHelperNode(List<Pair<String, Integer>> helperNodes, Frontend fe) {
        return helperNodes.stream().anyMatch(p -> ((String)p.first).equals(fe.getHost()) && ((Integer)p.second).intValue() == fe.getEditLogPort());
    }

    private static boolean isJoin(List<Pair<String, Integer>> allFeHosts, Frontend fe) {
        for (Pair<String, Integer> pair : allFeHosts) {
            if (!fe.getHost().equals(pair.first) || fe.getEditLogPort() != ((Integer)pair.second).intValue()) continue;
            return true;
        }
        return false;
    }

    private static List<Pair<String, Integer>> convertToHostPortPair(List<InetSocketAddress> addrs) {
        ArrayList hostPortPair = Lists.newArrayList();
        for (InetSocketAddress addr : addrs) {
            hostPortPair.add(Pair.create(addr.getAddress().getHostAddress(), addr.getPort()));
        }
        return hostPortPair;
    }
}

