/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.load.ExportMgr;

public class ExportProcNode
implements ProcNodeInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"JobId").add((Object)"Label").add((Object)"State").add((Object)"Progress").add((Object)"TaskInfo").add((Object)"Path").add((Object)"CreateTime").add((Object)"StartTime").add((Object)"FinishTime").add((Object)"Timeout").add((Object)"ErrorMsg").build();
    public static final int LABEL_INDEX = 1;
    public static final int STATE_INDEX = 2;
    private static final int LIMIT = 2000;
    private ExportMgr exportMgr;
    private Database db;

    public ExportProcNode(ExportMgr exportMgr, Database db) {
        this.exportMgr = exportMgr;
        this.db = db;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.db);
        Preconditions.checkNotNull((Object)this.exportMgr);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        List<List<String>> jobInfos = this.exportMgr.getExportJobInfosByIdOrState(this.db.getId(), 0L, "", false, null, null, 2000L);
        result.setRows(jobInfos);
        return result;
    }

    public static int analyzeColumn(String columnName) throws AnalysisException {
        for (String title : TITLE_NAMES) {
            if (!title.equalsIgnoreCase(columnName)) continue;
            return TITLE_NAMES.indexOf((Object)title);
        }
        throw new AnalysisException("Title name[" + columnName + "] does not exist");
    }
}

