/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.EsTable;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.external.elasticsearch.EsShardPartitions;
import org.apache.doris.external.elasticsearch.EsShardRouting;

public class EsShardProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"ShardId").add((Object)"Host").add((Object)"IsPrimary").build();
    private Database db;
    private EsTable esTable;
    private String indexName;

    public EsShardProcDir(Database db, EsTable esTable, String indexName) {
        this.db = db;
        this.esTable = esTable;
        this.indexName = indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcResult fetchResult() {
        Preconditions.checkNotNull((Object)this.db);
        Preconditions.checkNotNull((Object)this.esTable);
        Preconditions.checkNotNull((Object)this.indexName);
        ArrayList shardInfos = new ArrayList();
        this.esTable.readLock();
        try {
            EsShardPartitions esShardPartitions = this.esTable.getEsTablePartitions().getEsShardPartitions(this.indexName);
            for (int shardId : esShardPartitions.getShardRoutings().keySet()) {
                List<EsShardRouting> shardRoutings = esShardPartitions.getShardRoutings().get(shardId);
                if (shardRoutings != null && shardRoutings.size() > 0) {
                    for (EsShardRouting esShardRouting : shardRoutings) {
                        ArrayList<Object> shardInfo = new ArrayList<Object>();
                        shardInfo.add(shardId);
                        shardInfo.add(esShardRouting.getAddress().toString());
                        shardInfo.add(esShardRouting.isPrimary());
                        shardInfos.add(shardInfo);
                    }
                    continue;
                }
                ArrayList<Object> shardInfo = new ArrayList<Object>();
                shardInfo.add(shardId);
                shardInfo.add("");
                shardInfo.add(false);
                shardInfos.add(shardInfo);
            }
        }
        finally {
            this.esTable.readUnlock();
        }
        ListComparator comparator = new ListComparator(0, 1);
        Collections.sort(shardInfos, comparator);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        for (int i = 0; i < shardInfos.size(); ++i) {
            List info = (List)shardInfos.get(i);
            ArrayList<String> row = new ArrayList<String>(info.size());
            for (int j = 0; j < info.size(); ++j) {
                row.add(((Comparable)info.get(j)).toString());
            }
            result.addRow(row);
        }
        return result;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String shardIdStr) throws AnalysisException {
        return null;
    }
}

