/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.EsTable;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.EsShardProcDir;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.external.elasticsearch.EsShardPartitions;

public class EsPartitionsProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"IndexName").add((Object)"PartitionKey").add((Object)"Range").add((Object)"DistributionKey").add((Object)"Shards").add((Object)"ReplicationNum").build();
    public static final int PARTITION_NAME_INDEX = 1;
    private Database db;
    private EsTable esTable;

    public EsPartitionsProcDir(Database db, EsTable esTable) {
        this.db = db;
        this.esTable = esTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.db);
        Preconditions.checkNotNull((Object)this.esTable);
        Preconditions.checkState((this.esTable.getType() == Table.TableType.ELASTICSEARCH ? 1 : 0) != 0);
        ArrayList partitionInfos = new ArrayList();
        this.esTable.readLock();
        try {
            ArrayList<Object> partitionInfo;
            RangePartitionInfo rangePartitionInfo = null;
            if (this.esTable.getPartitionInfo().getType() == PartitionType.RANGE) {
                rangePartitionInfo = (RangePartitionInfo)this.esTable.getEsTablePartitions().getPartitionInfo();
            }
            Joiner joiner = Joiner.on((String)", ");
            Map<String, EsShardPartitions> map = this.esTable.getEsTablePartitions().getUnPartitionedIndexStates();
            Map<String, EsShardPartitions> partitionedIndices = this.esTable.getEsTablePartitions().getPartitionedIndexStates();
            for (EsShardPartitions esShardPartitions : map.values()) {
                partitionInfo = new ArrayList<Object>();
                partitionInfo.add(esShardPartitions.getIndexName());
                partitionInfo.add("-");
                partitionInfo.add("-");
                partitionInfo.add("-");
                partitionInfo.add(esShardPartitions.getShardRoutings().size());
                partitionInfo.add(1);
                partitionInfos.add(partitionInfo);
            }
            for (EsShardPartitions esShardPartitions : partitionedIndices.values()) {
                partitionInfo = new ArrayList();
                partitionInfo.add(esShardPartitions.getIndexName());
                List<Column> partitionColumns = rangePartitionInfo.getPartitionColumns();
                ArrayList<String> colNames = new ArrayList<String>();
                for (Column column : partitionColumns) {
                    colNames.add(column.getName());
                }
                partitionInfo.add(joiner.join(colNames));
                partitionInfo.add(rangePartitionInfo.getItem(esShardPartitions.getPartitionId()).getItems().toString());
                partitionInfo.add("-");
                partitionInfo.add(esShardPartitions.getShardRoutings().size());
                partitionInfo.add(1);
                partitionInfos.add(partitionInfo);
            }
        }
        finally {
            this.esTable.readUnlock();
        }
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        for (List list : partitionInfos) {
            ArrayList<String> row = new ArrayList<String>(list.size());
            for (Comparable comparable : list) {
                row.add(comparable.toString());
            }
            result.addRow(row);
        }
        return result;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String indexName) throws AnalysisException {
        return new EsShardProcDir(this.db, this.esTable, indexName);
    }
}

