/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.load.DeleteHandler;
import org.apache.doris.load.Load;

public class DeleteInfoProcDir
implements ProcNodeInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"TableName").add((Object)"PartitionName").add((Object)"CreateTime").add((Object)"DeleteCondition").add((Object)"State").build();
    private Load load;
    private DeleteHandler deleteHandler;
    private long dbId;

    public DeleteInfoProcDir(DeleteHandler deleteHandler, Load load, long dbId) {
        this.load = load;
        this.deleteHandler = deleteHandler;
        this.dbId = dbId;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        List<List<Comparable>> infos = this.deleteHandler.getDeleteInfosByDb(this.dbId);
        for (List<Comparable> info : infos) {
            ArrayList<String> oneInfo = new ArrayList<String>(TITLE_NAMES.size());
            for (Comparable element : info) {
                oneInfo.add(element.toString());
            }
            result.addRow(oneInfo);
        }
        return result;
    }
}

