/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.TablesProcDir;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.common.util.TimeUtils;

public class DbsProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"DbId").add((Object)"DbName").add((Object)"TableNum").add((Object)"Quota").add((Object)"LastConsistencyCheckTime").add((Object)"ReplicaQuota").build();
    private Catalog catalog;

    public DbsProcDir(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String dbIdStr) throws AnalysisException {
        if (this.catalog == null || Strings.isNullOrEmpty((String)dbIdStr)) {
            throw new AnalysisException("Db id is null");
        }
        long dbId = -1L;
        try {
            dbId = Long.valueOf(dbIdStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid db id format: " + dbIdStr);
        }
        Database db = this.catalog.getDbOrAnalysisException(dbId);
        return new TablesProcDir(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.catalog);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        List<String> dbNames = this.catalog.getDbNames();
        if (dbNames == null || dbNames.isEmpty()) {
            return result;
        }
        ArrayList dbInfos = new ArrayList();
        for (String dbName : dbNames) {
            Database database = this.catalog.getDbNullable(dbName);
            if (database == null) continue;
            ArrayList<Object> dbInfo = new ArrayList<Object>();
            database.readLock();
            try {
                int tableNum = database.getTables().size();
                dbInfo.add(database.getId());
                dbInfo.add(dbName);
                dbInfo.add(tableNum);
                long dataQuota = database.getDataQuota();
                Pair<Double, String> quotaUnitPair = DebugUtil.getByteUint(dataQuota);
                String readableQuota = DebugUtil.DECIMAL_FORMAT_SCALE_3.format(quotaUnitPair.first) + " " + (String)quotaUnitPair.second;
                dbInfo.add(readableQuota);
                dbInfo.add(TimeUtils.longToTimeString(database.getLastCheckTime()));
                long replicaQuota = database.getReplicaQuota();
                dbInfo.add(replicaQuota);
            }
            finally {
                database.readUnlock();
            }
            dbInfos.add(dbInfo);
        }
        ListComparator comparator = new ListComparator(0);
        Collections.sort(dbInfos, comparator);
        for (List list : dbInfos) {
            ArrayList<String> row = new ArrayList<String>(list.size());
            for (Comparable comparable : list) {
                row.add(comparable.toString());
            }
            result.addRow(row);
        }
        return result;
    }
}

