/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.CurrentQueryInfoProvider;
import org.apache.doris.common.proc.CurrentQuerySqlProcDir;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.util.QueryStatisticsFormatter;
import org.apache.doris.qe.QeProcessorImpl;
import org.apache.doris.qe.QueryStatisticsItem;

public class CurrentQueryStatisticsProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"QueryId").add((Object)"ConnectionId").add((Object)"Database").add((Object)"User").add((Object)"ScanBytes").add((Object)"ProcessRows").add((Object)"ExecTime").build();
    private static final int EXEC_TIME_INDEX = 6;

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String name) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        Map<String, QueryStatisticsItem> statistic = QeProcessorImpl.INSTANCE.getQueryStatistics();
        QueryStatisticsItem item = statistic.get(name);
        if (item == null) {
            throw new AnalysisException(name + " doesn't exist.");
        }
        return new CurrentQuerySqlProcDir(item);
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        Map<String, QueryStatisticsItem> statistic = QeProcessorImpl.INSTANCE.getQueryStatistics();
        result.setNames((List<String>)TITLE_NAMES.asList());
        ArrayList sortedRowData = Lists.newArrayList();
        CurrentQueryInfoProvider provider = new CurrentQueryInfoProvider();
        Map<String, CurrentQueryInfoProvider.QueryStatistics> statisticsMap = provider.getQueryStatistics(statistic.values());
        for (QueryStatisticsItem item : statistic.values()) {
            ArrayList values = Lists.newArrayList();
            values.add(item.getQueryId());
            values.add(item.getConnId());
            values.add(item.getDb());
            values.add(item.getUser());
            if (item.getIsReportSucc()) {
                CurrentQueryInfoProvider.QueryStatistics statistics = statisticsMap.get(item.getQueryId());
                values.add(QueryStatisticsFormatter.getScanBytes(statistics.getScanBytes()));
                values.add(QueryStatisticsFormatter.getRowsReturned(statistics.getRowsReturned()));
            } else {
                values.add("N/A");
                values.add("N/A");
            }
            values.add(item.getQueryExecTime());
            sortedRowData.add(values);
        }
        sortedRowData.sort((l1, l2) -> {
            int execTime1 = Integer.parseInt((String)l1.get(6));
            int execTime2 = Integer.parseInt((String)l2.get(6));
            return execTime2 - execTime1;
        });
        result.setRows(sortedRowData);
        return result;
    }
}

