/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.CurrentQueryInfoProvider;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.qe.QeProcessorImpl;
import org.apache.doris.qe.QueryStatisticsItem;

public class CurrentQueryStatementsProcNode
implements ProcNodeInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"QueryId").add((Object)"ConnectionId").add((Object)"Database").add((Object)"User").add((Object)"ExecTime").add((Object)"SqlHash").add((Object)"Statement").build();
    private static final int EXEC_TIME_INDEX = 4;

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        Map<String, QueryStatisticsItem> statistic = QeProcessorImpl.INSTANCE.getQueryStatistics();
        result.setNames((List<String>)TITLE_NAMES.asList());
        ArrayList sortedRowData = Lists.newArrayList();
        CurrentQueryInfoProvider provider = new CurrentQueryInfoProvider();
        Map<String, CurrentQueryInfoProvider.QueryStatistics> statisticsMap = provider.getQueryStatistics(statistic.values());
        for (QueryStatisticsItem item : statistic.values()) {
            ArrayList values = Lists.newArrayList();
            values.add(item.getQueryId());
            values.add(item.getConnId());
            values.add(item.getDb());
            values.add(item.getUser());
            values.add(item.getQueryExecTime());
            values.add(DigestUtils.md5Hex((String)item.getSql()));
            values.add(item.getSql());
            sortedRowData.add(values);
        }
        sortedRowData.sort((l1, l2) -> {
            int execTime1 = Integer.parseInt((String)l1.get(4));
            int execTime2 = Integer.parseInt((String)l2.get(4));
            return execTime2 - execTime1;
        });
        result.setRows(sortedRowData);
        return result;
    }
}

