/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.CurrentQueryFragmentProcNode;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.qe.QueryStatisticsItem;

public class CurrentQuerySqlProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"Sql").build();
    private final QueryStatisticsItem item;

    public CurrentQuerySqlProcDir(QueryStatisticsItem item) {
        this.item = item;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String name) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        if (!name.equals("fragments")) {
            throw new AnalysisException(name + " doesn't exist.");
        }
        return new CurrentQueryFragmentProcNode(this.item);
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES.asList());
        ArrayList values = Lists.newArrayList();
        values.add(this.item.getSql());
        result.addRow(values);
        return result;
    }
}

