/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.util.Counter;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.RuntimeProfile;
import org.apache.doris.qe.QueryStatisticsItem;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TUniqueId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CurrentQueryInfoProvider {
    private static final Logger LOG = LogManager.getLogger(CurrentQueryInfoProvider.class);

    public QueryStatistics getQueryStatistics(QueryStatisticsItem item) throws AnalysisException {
        return new QueryStatistics(item.getQueryProfile());
    }

    public Map<String, QueryStatistics> getQueryStatistics(Collection<QueryStatisticsItem> items) {
        HashMap queryStatisticsMap = Maps.newHashMap();
        for (QueryStatisticsItem item : items) {
            queryStatisticsMap.put(item.getQueryId(), new QueryStatistics(item.getQueryProfile()));
        }
        return queryStatisticsMap;
    }

    public Collection<InstanceStatistics> getInstanceStatistics(QueryStatisticsItem item) throws AnalysisException {
        Map<String, RuntimeProfile> instanceProfiles = this.collectInstanceProfile(item.getQueryProfile());
        ArrayList instanceStatisticsList = Lists.newArrayList();
        for (QueryStatisticsItem.FragmentInstanceInfo instanceInfo : item.getFragmentInstanceInfos()) {
            RuntimeProfile instanceProfile = instanceProfiles.get(DebugUtil.printId(instanceInfo.getInstanceId()));
            Preconditions.checkNotNull((Object)instanceProfile);
            InstanceStatistics Statistics2 = new InstanceStatistics(instanceInfo.getFragmentId(), instanceInfo.getInstanceId(), instanceInfo.getAddress(), instanceProfile);
            instanceStatisticsList.add(Statistics2);
        }
        return instanceStatisticsList;
    }

    private Map<String, RuntimeProfile> collectInstanceProfile(RuntimeProfile queryProfile) {
        HashMap instanceProfiles = Maps.newHashMap();
        for (RuntimeProfile fragmentProfile : queryProfile.getChildMap().values()) {
            for (Map.Entry<String, RuntimeProfile> entry : fragmentProfile.getChildMap().entrySet()) {
                Preconditions.checkState((instanceProfiles.put(this.parseInstanceId(entry.getKey()), entry.getValue()) == null ? 1 : 0) != 0);
            }
        }
        return instanceProfiles;
    }

    private String parseInstanceId(String str) {
        String[] elements = str.split(" ");
        if (elements.length == 4) {
            return elements[1];
        }
        Preconditions.checkState((boolean)false);
        return "";
    }

    public static class InstanceStatistics {
        private final String fragmentId;
        private final TUniqueId instanceId;
        private final TNetworkAddress address;
        private final QueryStatistics statistics;

        public InstanceStatistics(String fragmentId, TUniqueId instanceId, TNetworkAddress address, RuntimeProfile profile) {
            this.fragmentId = fragmentId;
            this.instanceId = instanceId;
            this.address = address;
            this.statistics = new QueryStatistics(profile);
        }

        public String getFragmentId() {
            return this.fragmentId;
        }

        public TUniqueId getInstanceId() {
            return this.instanceId;
        }

        public TNetworkAddress getAddress() {
            return this.address;
        }

        public long getRowsReturned() {
            return this.statistics.getRowsReturned();
        }

        public long getScanBytes() {
            return this.statistics.getScanBytes();
        }
    }

    public static class QueryStatistics {
        final List<Map<String, Counter>> counterMaps = Lists.newArrayList();

        public QueryStatistics(RuntimeProfile profile) {
            this.collectCounters(profile, this.counterMaps);
        }

        private void collectCounters(RuntimeProfile profile, List<Map<String, Counter>> counterMaps) {
            for (Map.Entry<String, RuntimeProfile> entry : profile.getChildMap().entrySet()) {
                counterMaps.add(entry.getValue().getCounterMap());
                this.collectCounters(entry.getValue(), counterMaps);
            }
        }

        public long getScanBytes() {
            long scanBytes = 0L;
            for (Map<String, Counter> counters : this.counterMaps) {
                Counter counter = counters.get("CompressedBytesRead");
                scanBytes += counter == null ? 0L : counter.getValue();
            }
            return scanBytes;
        }

        public long getRowsReturned() {
            long rowsReturned = 0L;
            for (Map<String, Counter> counters : this.counterMaps) {
                Counter counter = counters.get("RowsReturned");
                rowsReturned += counter == null ? 0L : counter.getValue();
            }
            return rowsReturned;
        }
    }
}

