/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.CurrentQueryInfoProvider;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.util.QueryStatisticsFormatter;
import org.apache.doris.qe.QueryStatisticsItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CurrentQueryFragmentProcNode
implements ProcNodeInterface {
    private static final Logger LOG = LogManager.getLogger(CurrentQueryFragmentProcNode.class);
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"FragmentId").add((Object)"InstanceId").add((Object)"Host").add((Object)"ScanBytes").add((Object)"ProcessRows").build();
    private QueryStatisticsItem item;

    public CurrentQueryFragmentProcNode(QueryStatisticsItem item) {
        this.item = item;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        return this.requestFragmentExecInfos();
    }

    private ProcResult requestFragmentExecInfos() throws AnalysisException {
        CurrentQueryInfoProvider provider = new CurrentQueryInfoProvider();
        Collection<CurrentQueryInfoProvider.InstanceStatistics> instanceStatisticsCollection = provider.getInstanceStatistics(this.item);
        ArrayList sortedRowData = Lists.newArrayList();
        for (CurrentQueryInfoProvider.InstanceStatistics instanceStatistics : instanceStatisticsCollection) {
            ArrayList rowData = Lists.newArrayList();
            rowData.add(instanceStatistics.getFragmentId());
            rowData.add(instanceStatistics.getInstanceId().toString());
            rowData.add(instanceStatistics.getAddress().toString());
            if (this.item.getIsReportSucc()) {
                rowData.add(QueryStatisticsFormatter.getScanBytes(instanceStatistics.getScanBytes()));
                rowData.add(QueryStatisticsFormatter.getRowsReturned(instanceStatistics.getRowsReturned()));
            } else {
                rowData.add("N/A");
                rowData.add("N/A");
            }
            sortedRowData.add(rowData);
        }
        sortedRowData.sort(new Comparator<List<String>>(){

            @Override
            public int compare(List<String> l1, List<String> l2) {
                return l1.get(0).compareTo(l2.get(0));
            }
        });
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES.asList());
        result.setRows(sortedRowData);
        return result;
    }
}

