/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.qe.QeProcessorImpl;
import org.apache.doris.qe.QueryStatisticsItem;

public class CurrentQueryBackendInstanceProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"Backend").add((Object)"InstanceNum").add((Object)"InstanceId").add((Object)"ExecTime").build();

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String name) throws AnalysisException {
        throw new AnalysisException(name + " doesn't exist.");
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        return this.constructQueryInstanceInfo();
    }

    private ProcResult constructQueryInstanceInfo() {
        Map<String, QueryStatisticsItem> currentQueryMap = QeProcessorImpl.INSTANCE.getQueryStatistics();
        HashMap hostInstances = Maps.newHashMap();
        for (QueryStatisticsItem item : currentQueryMap.values()) {
            for (QueryStatisticsItem.FragmentInstanceInfo info : item.getFragmentInstanceInfos()) {
                RowData content = new RowData();
                String address = info.getAddress().getHostname() + ":" + info.getAddress().getPort();
                content.setHost(address);
                content.setInstanceId(DebugUtil.printId(info.getInstanceId()));
                content.setExecTime(item.getQueryExecTime());
                String hostWithPort = info.getAddress().toString();
                List list = (List)hostInstances.get(hostWithPort);
                if (list == null) {
                    list = Lists.newArrayList();
                    hostInstances.put(hostWithPort, list);
                }
                list.add(content);
            }
        }
        ArrayList sortedRowData = Lists.newArrayList();
        sortedRowData.addAll(hostInstances.values());
        sortedRowData.sort(new Comparator<List<RowData>>(){

            @Override
            public int compare(List<RowData> l1, List<RowData> l2) {
                return l1.size() <= l2.size() ? 1 : -1;
            }
        });
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES.asList());
        for (List itemList : sortedRowData) {
            for (RowData item : itemList) {
                ArrayList rowData = Lists.newArrayList();
                rowData.add(item.getHost());
                rowData.add(String.valueOf(itemList.size()));
                rowData.add(item.getInstanceId());
                rowData.add(item.getExecTime());
                result.addRow(rowData);
            }
        }
        return result;
    }

    private static class RowData {
        private String host;
        private String backendId;
        private String instanceId;
        private String execTime;

        private RowData() {
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getBackendId() {
            return this.backendId;
        }

        public void setBackendId(String backendId) {
            this.backendId = backendId;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getExecTime() {
            return this.execTime;
        }

        public void setExecTime(String execTime) {
            this.execTime = execTime;
        }
    }
}

