/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.resource.Tag;

public class ColocationGroupBackendSeqsProcNode
implements ProcNodeInterface {
    private Map<Tag, List<List<Long>>> backendsSeq;

    public ColocationGroupBackendSeqsProcNode(Map<Tag, List<List<Long>>> backendsSeq) {
        this.backendsSeq = backendsSeq;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        ArrayList titleNames = Lists.newArrayList();
        titleNames.add("BucketIndex");
        int bucketNum = 0;
        for (Tag tag : this.backendsSeq.keySet()) {
            titleNames.add(tag.toString());
            if (bucketNum == 0) {
                bucketNum = this.backendsSeq.get(tag).size();
                continue;
            }
            if (bucketNum == this.backendsSeq.get(tag).size()) continue;
            throw new AnalysisException("Invalid bucket number: " + bucketNum + " vs. " + this.backendsSeq.get(tag).size());
        }
        result.setNames(titleNames);
        for (int i = 0; i < bucketNum; ++i) {
            ArrayList info = Lists.newArrayList();
            info.add(String.valueOf(i));
            for (Tag tag : this.backendsSeq.keySet()) {
                List<List<Long>> bucketBackends = this.backendsSeq.get(tag);
                info.add(Joiner.on((String)", ").join((Iterable)bucketBackends.get(i)));
            }
            result.addRow(info);
        }
        return result;
    }
}

