/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.clone.ClusterLoadStatistic;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BackendLoadStatisticProcNode;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.resource.Tag;
import org.apache.doris.system.Backend;
import org.apache.doris.thrift.TStorageMedium;

public class ClusterLoadStatisticProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"BeId").add((Object)"Cluster").add((Object)"Available").add((Object)"UsedCapacity").add((Object)"Capacity").add((Object)"UsedPercent").add((Object)"ReplicaNum").add((Object)"CapCoeff").add((Object)"ReplCoeff").add((Object)"Score").add((Object)"Class").build();
    private Tag tag;
    private TStorageMedium medium;

    public ClusterLoadStatisticProcDir(Tag tag, TStorageMedium medium) {
        this.tag = tag;
        this.medium = medium;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        Map map = Catalog.getCurrentCatalog().getTabletScheduler().getStatisticMap().column((Object)this.tag);
        map.values().forEach(t -> {
            List<List<String>> statistics = t.getClusterStatistic(this.medium);
            statistics.forEach(result::addRow);
        });
        return result;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String beIdStr) throws AnalysisException {
        long beId = -1L;
        try {
            beId = Long.valueOf(beIdStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid be id format: " + beIdStr);
        }
        Backend be = Catalog.getCurrentSystemInfo().getBackend(beId);
        if (be == null) {
            throw new AnalysisException("backend " + beId + " does not exist");
        }
        Map map = Catalog.getCurrentCatalog().getTabletScheduler().getStatisticMap().column((Object)this.tag);
        return new BackendLoadStatisticProcNode((ClusterLoadStatistic)map.get(be.getOwnerClusterName()), beId);
    }
}

