/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ClusterLoadStatisticProcDir;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.resource.Tag;
import org.apache.doris.thrift.TStorageMedium;

public class ClusterLoadStatByTagAndMedium
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"StorageMedium").build();
    private Tag tag;

    public ClusterLoadStatByTagAndMedium(Tag tag) {
        this.tag = tag;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        for (TStorageMedium medium : TStorageMedium.values()) {
            result.addRow(Lists.newArrayList((Object[])new String[]{medium.name()}));
        }
        return result;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String name) throws AnalysisException {
        for (TStorageMedium medium : TStorageMedium.values()) {
            if (!name.equalsIgnoreCase(medium.name())) continue;
            return new ClusterLoadStatisticProcDir(this.tag, medium);
        }
        throw new AnalysisException("no such storage medium: " + name);
    }
}

