/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ClusterLoadStatByTagAndMedium;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.resource.Tag;
import org.apache.doris.system.Backend;

public class ClusterLoadStatByTag
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"Tag").build();

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        Set<Tag> tags = this.genTagMap();
        for (Tag tag : tags) {
            result.addRow(Lists.newArrayList((Object[])new String[]{tag.toKey()}));
        }
        return result;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String name) throws AnalysisException {
        Set<Tag> tags = this.genTagMap();
        HashMap tagMap = Maps.newHashMap();
        for (Tag tag : tags) {
            tagMap.put(tag.toKey(), tag);
        }
        Tag tag = (Tag)tagMap.get(name);
        if (tag == null) {
            throw new AnalysisException("No such tag: " + name);
        }
        return new ClusterLoadStatByTagAndMedium(tag);
    }

    private Set<Tag> genTagMap() {
        HashSet tags = Sets.newHashSet();
        List<Long> beIds = Catalog.getCurrentSystemInfo().getBackendIds(false);
        for (long beId : beIds) {
            Backend be = Catalog.getCurrentSystemInfo().getBackend(beId);
            if (be == null) continue;
            tags.add(be.getTag());
        }
        return tags;
    }
}

