/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.clone.TabletChecker;
import org.apache.doris.clone.TabletScheduler;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ClusterLoadStatByTag;
import org.apache.doris.common.proc.PriorityRepairProcNode;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.proc.SchedulerStatProcNode;
import org.apache.doris.common.proc.SchedulerWorkingSlotsProcDir;
import org.apache.doris.common.proc.TabletSchedulerDetailProcDir;

public class ClusterBalanceProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"Item").add((Object)"Number").build();
    public static final String CLUSTER_LOAD = "cluster_load_stat";
    public static final String WORKING_SLOTS = "working_slots";
    public static final String SCHED_STAT = "sched_stat";
    public static final String PRIORITY_REPAIR = "priority_repair";
    public static final String PENDING_TABLETS = "pending_tablets";
    public static final String RUNNING_TABLETS = "running_tablets";
    public static final String HISTORY_TABLETS = "history_tablets";

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String name) throws AnalysisException {
        if (name.equals(CLUSTER_LOAD)) {
            return new ClusterLoadStatByTag();
        }
        if (name.equals(WORKING_SLOTS)) {
            return new SchedulerWorkingSlotsProcDir();
        }
        if (name.equals(SCHED_STAT)) {
            return new SchedulerStatProcNode();
        }
        if (name.equals(PRIORITY_REPAIR)) {
            return new PriorityRepairProcNode();
        }
        return new TabletSchedulerDetailProcDir(name);
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        TabletScheduler tabletScheduler = Catalog.getCurrentCatalog().getTabletScheduler();
        TabletChecker tabletChecker = Catalog.getCurrentCatalog().getTabletChecker();
        result.addRow(Lists.newArrayList((Object[])new String[]{CLUSTER_LOAD, String.valueOf(tabletScheduler.getStatisticMap().size())}));
        result.addRow(Lists.newArrayList((Object[])new String[]{WORKING_SLOTS, String.valueOf(tabletScheduler.getBackendsWorkingSlots().size())}));
        result.addRow(Lists.newArrayList((Object[])new String[]{SCHED_STAT, tabletScheduler.getStat().getLastSnapshot() == null ? "0" : "1"}));
        result.addRow(Lists.newArrayList((Object[])new String[]{PRIORITY_REPAIR, String.valueOf(tabletChecker.getPrioPartitionNum())}));
        result.addRow(Lists.newArrayList((Object[])new String[]{PENDING_TABLETS, String.valueOf(tabletScheduler.getPendingNum())}));
        result.addRow(Lists.newArrayList((Object[])new String[]{RUNNING_TABLETS, String.valueOf(tabletScheduler.getRunningNum())}));
        result.addRow(Lists.newArrayList((Object[])new String[]{HISTORY_TABLETS, String.valueOf(tabletScheduler.getHistoryNum())}));
        return result;
    }
}

