/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;

public class BaseProcDir
implements ProcDirInterface {
    protected Map<String, ProcNodeInterface> nodeMap = Maps.newConcurrentMap();

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        this.nodeMap.put(name, node);
        return true;
    }

    @Override
    public ProcNodeInterface lookup(String name) {
        return this.nodeMap.get(name);
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames(Lists.newArrayList((Object[])new String[]{"name"}));
        ArrayList nameList = Lists.newArrayList(this.nodeMap.keySet());
        Collections.sort(nameList);
        for (String name : nameList) {
            result.addRow(Lists.newArrayList((Object[])new String[]{name}));
        }
        return result;
    }
}

