/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.doris.alter.DecommissionType;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.Cluster;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.proc.BackendProcNode;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.common.util.ListComparator;
import org.apache.doris.common.util.NetUtils;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.system.Backend;
import org.apache.doris.system.SystemInfoService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackendsProcDir
implements ProcDirInterface {
    private static final Logger LOG = LogManager.getLogger(BackendsProcDir.class);
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"BackendId").add((Object)"Cluster").add((Object)"IP").add((Object)"HostName").add((Object)"HeartbeatPort").add((Object)"BePort").add((Object)"HttpPort").add((Object)"BrpcPort").add((Object)"LastStartTime").add((Object)"LastHeartbeat").add((Object)"Alive").add((Object)"SystemDecommissioned").add((Object)"ClusterDecommissioned").add((Object)"TabletNum").add((Object)"DataUsedCapacity").add((Object)"AvailCapacity").add((Object)"TotalCapacity").add((Object)"UsedPct").add((Object)"MaxDiskUsedPct").add((Object)"Tag").add((Object)"ErrMsg").add((Object)"Version").add((Object)"Status").build();
    public static final int HOSTNAME_INDEX = 3;
    private SystemInfoService clusterInfoService;

    public BackendsProcDir(SystemInfoService clusterInfoService) {
        this.clusterInfoService = clusterInfoService;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.clusterInfoService);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        List<List<String>> backendInfos = BackendsProcDir.getClusterBackendInfos(null);
        for (List<String> backendInfo : backendInfos) {
            ArrayList<String> oneInfo = new ArrayList<String>(backendInfo.size());
            oneInfo.addAll(backendInfo);
            result.addRow(oneInfo);
        }
        return result;
    }

    public static List<List<String>> getClusterBackendInfos(String clusterName) {
        List<Long> backendIds;
        SystemInfoService clusterInfoService = Catalog.getCurrentSystemInfo();
        LinkedList<List<String>> backendInfos = new LinkedList<List<String>>();
        if (!Strings.isNullOrEmpty((String)clusterName)) {
            Cluster cluster = Catalog.getCurrentCatalog().getCluster(clusterName);
            if (null == cluster) {
                return backendInfos;
            }
            backendIds = cluster.getBackendIdList();
        } else {
            backendIds = clusterInfoService.getBackendIds(false);
            if (backendIds == null) {
                return backendInfos;
            }
        }
        long start = System.currentTimeMillis();
        Stopwatch watch = Stopwatch.createUnstarted();
        LinkedList<ArrayList<Object>> comparableBackendInfos = new LinkedList<ArrayList<Object>>();
        for (long backendId : backendIds) {
            Backend backend = clusterInfoService.getBackend(backendId);
            if (backend == null) continue;
            watch.start();
            Integer tabletNum = Catalog.getCurrentInvertedIndex().getTabletNumByBackendId(backendId);
            watch.stop();
            ArrayList backendInfo = Lists.newArrayList();
            backendInfo.add(String.valueOf(backendId));
            backendInfo.add(backend.getOwnerClusterName());
            backendInfo.add(backend.getHost());
            if (Strings.isNullOrEmpty((String)clusterName)) {
                backendInfo.add(NetUtils.getHostnameByIp(backend.getHost()));
                backendInfo.add(String.valueOf(backend.getHeartbeatPort()));
                backendInfo.add(String.valueOf(backend.getBePort()));
                backendInfo.add(String.valueOf(backend.getHttpPort()));
                backendInfo.add(String.valueOf(backend.getBrpcPort()));
            }
            backendInfo.add(TimeUtils.longToTimeString(backend.getLastStartTime()));
            backendInfo.add(TimeUtils.longToTimeString(backend.getLastUpdateMs()));
            backendInfo.add(String.valueOf(backend.isAlive()));
            if (backend.isDecommissioned() && backend.getDecommissionType() == DecommissionType.ClusterDecommission) {
                backendInfo.add("false");
                backendInfo.add("true");
            } else if (backend.isDecommissioned() && backend.getDecommissionType() == DecommissionType.SystemDecommission) {
                backendInfo.add("true");
                backendInfo.add("false");
            } else {
                backendInfo.add("false");
                backendInfo.add("false");
            }
            backendInfo.add(tabletNum.toString());
            long dataUsedB = backend.getDataUsedCapacityB();
            Pair<Double, String> usedCapacity = DebugUtil.getByteUint(dataUsedB);
            backendInfo.add(DebugUtil.DECIMAL_FORMAT_SCALE_3.format(usedCapacity.first) + " " + (String)usedCapacity.second);
            long availB = backend.getAvailableCapacityB();
            Pair<Double, String> availCapacity = DebugUtil.getByteUint(availB);
            backendInfo.add(DebugUtil.DECIMAL_FORMAT_SCALE_3.format(availCapacity.first) + " " + (String)availCapacity.second);
            long totalB = backend.getTotalCapacityB();
            Pair<Double, String> totalCapacity = DebugUtil.getByteUint(totalB);
            backendInfo.add(DebugUtil.DECIMAL_FORMAT_SCALE_3.format(totalCapacity.first) + " " + (String)totalCapacity.second);
            double used = 0.0;
            used = totalB <= 0L ? 0.0 : (double)(totalB - availB) * 100.0 / (double)totalB;
            backendInfo.add(String.format("%.2f", used) + " %");
            backendInfo.add(String.format("%.2f", backend.getMaxDiskUsedPct() * 100.0) + " %");
            backendInfo.add(backend.getTag().toString());
            backendInfo.add(backend.getHeartbeatErrMsg());
            backendInfo.add(backend.getVersion());
            backendInfo.add(new Gson().toJson((Object)backend.getBackendStatus()));
            comparableBackendInfos.add(backendInfo);
        }
        LOG.debug("backends proc get tablet num cost: {}, total cost: {}", (Object)watch.elapsed(TimeUnit.MILLISECONDS), (Object)(System.currentTimeMillis() - start));
        ListComparator comparator = new ListComparator(1, 3);
        comparableBackendInfos.sort(comparator);
        for (List list : comparableBackendInfos) {
            ArrayList<String> oneInfo = new ArrayList<String>(list.size());
            for (Comparable element : list) {
                oneInfo.add(element.toString());
            }
            backendInfos.add(oneInfo);
        }
        return backendInfos;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String beIdStr) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)beIdStr)) {
            throw new AnalysisException("Backend id is null");
        }
        long backendId = -1L;
        try {
            backendId = Long.parseLong(beIdStr);
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid backend id format: " + beIdStr);
        }
        Backend backend = this.clusterInfoService.getBackend(backendId);
        if (backend == null) {
            throw new AnalysisException("Backend[" + backendId + "] does not exist.");
        }
        return new BackendProcNode(backend);
    }
}

