/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.DiskInfo;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.common.util.DebugUtil;
import org.apache.doris.system.Backend;

public class BackendProcNode
implements ProcNodeInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"RootPath").add((Object)"DataUsedCapacity").add((Object)"OtherUsedCapacity").add((Object)"AvailCapacity").add((Object)"TotalCapacity").add((Object)"TotalUsedPct").add((Object)"State").add((Object)"PathHash").build();
    private Backend backend;

    public BackendProcNode(Backend backend) {
        this.backend = backend;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        Preconditions.checkNotNull((Object)this.backend);
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        for (Map.Entry entry : this.backend.getDisks().entrySet()) {
            ArrayList info = Lists.newArrayList();
            info.add((String)entry.getKey());
            long dataUsedB = ((DiskInfo)entry.getValue()).getDataUsedCapacityB();
            Pair<Double, String> dataUsedUnitPair = DebugUtil.getByteUint(dataUsedB);
            info.add(DebugUtil.DECIMAL_FORMAT_SCALE_3.format(dataUsedUnitPair.first) + " " + (String)dataUsedUnitPair.second);
            long availB = ((DiskInfo)entry.getValue()).getAvailableCapacityB();
            Pair<Double, String> availUnitPair = DebugUtil.getByteUint(availB);
            long totalB = ((DiskInfo)entry.getValue()).getTotalCapacityB();
            Pair<Double, String> totalUnitPair = DebugUtil.getByteUint(totalB);
            long otherB = totalB - availB - dataUsedB;
            Pair<Double, String> otherUnitPair = DebugUtil.getByteUint(otherB);
            info.add(DebugUtil.DECIMAL_FORMAT_SCALE_3.format(otherUnitPair.first) + " " + (String)otherUnitPair.second);
            info.add(DebugUtil.DECIMAL_FORMAT_SCALE_3.format(availUnitPair.first) + " " + (String)availUnitPair.second);
            info.add(DebugUtil.DECIMAL_FORMAT_SCALE_3.format(totalUnitPair.first) + " " + (String)totalUnitPair.second);
            double used = 0.0;
            used = totalB <= 0L ? 0.0 : (double)(totalB - availB) * 100.0 / (double)totalB;
            info.add(String.format("%.2f", used) + " %");
            info.add(((DiskInfo)entry.getValue()).getState().name());
            info.add(String.valueOf(((DiskInfo)entry.getValue()).getPathHash()));
            result.addRow(info);
        }
        return result;
    }
}

