/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.doris.clone.ClusterLoadStatistic;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;

public class BackendLoadStatisticProcNode
implements ProcNodeInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"RootPath").add((Object)"PathHash").add((Object)"StorageMedium").add((Object)"DataUsedCapacity").add((Object)"TotalCapacity").add((Object)"TotalUsedPct").add((Object)"Class").add((Object)"State").build();
    private final ClusterLoadStatistic statistic;
    private final long beId;

    public BackendLoadStatisticProcNode(ClusterLoadStatistic statistic, long beId) {
        this.statistic = statistic;
        this.beId = beId;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        if (this.statistic != null) {
            result.setRows(this.statistic.getBackendStatistic(this.beId));
        }
        return result;
    }
}

