/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.proc.BDBJEDatabaseProcDir;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.journal.bdbje.BDBDebugger;

public class BDBJEProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"DbNames").add((Object)"JournalNumber").add((Object)"Comment").build();

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String dbName) throws AnalysisException {
        return new BDBJEDatabaseProcDir(dbName);
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        if (!Config.enable_bdbje_debug_mode) {
            throw new AnalysisException("Not in bdbje debug mode");
        }
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        BDBDebugger.BDBDebugEnv debugEnv = BDBDebugger.get().getEnv();
        List<String> dbNames = debugEnv.listDbNames();
        TreeMap<String, Long> journalNumMap = new TreeMap<String, Long>();
        for (String string : dbNames) {
            journalNumMap.put(string, debugEnv.getJournalNumber(string));
        }
        for (Map.Entry entry : journalNumMap.entrySet()) {
            result.addRow(Lists.newArrayList((Object[])new String[]{(String)entry.getKey(), ((Long)entry.getValue()).toString(), ""}));
        }
        return result;
    }
}

