/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.journal.bdbje.BDBDebugger;
import org.apache.doris.persist.OperationType;

public class BDBJEJournalDataProcNode
implements ProcNodeInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"JournalId").add((Object)"OpType").add((Object)"Data").build();
    private String dbName;
    private Long journalId;

    public BDBJEJournalDataProcNode(String dbName, Long journalId) {
        this.dbName = dbName;
        this.journalId = journalId;
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        if (!Config.enable_bdbje_debug_mode) {
            throw new AnalysisException("Not in bdbje debug mode");
        }
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        BDBDebugger.BDBDebugEnv env = BDBDebugger.get().getEnv();
        BDBDebugger.JournalEntityWrapper entity = env.getJournalEntity(this.dbName, this.journalId);
        short opCode = entity.entity == null ? (short)-1 : (short)entity.entity.getOpCode();
        String data = entity.entity == null ? entity.errMsg : entity.entity.getData().toString();
        result.addRow(Lists.newArrayList((Object[])new String[]{entity.journalId.toString(), OperationType.getOpName(opCode), data}));
        return result;
    }
}

