/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.proc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.proc.BDBJEJournalDataProcNode;
import org.apache.doris.common.proc.BaseProcResult;
import org.apache.doris.common.proc.ProcDirInterface;
import org.apache.doris.common.proc.ProcNodeInterface;
import org.apache.doris.common.proc.ProcResult;
import org.apache.doris.journal.bdbje.BDBDebugger;

public class BDBJEDatabaseProcDir
implements ProcDirInterface {
    public static final ImmutableList<String> TITLE_NAMES = new ImmutableList.Builder().add((Object)"JournalId").build();
    private String dbName;

    public BDBJEDatabaseProcDir(String dbName) {
        this.dbName = dbName;
    }

    @Override
    public boolean register(String name, ProcNodeInterface node) {
        return false;
    }

    @Override
    public ProcNodeInterface lookup(String journalId) throws AnalysisException {
        return new BDBJEJournalDataProcNode(this.dbName, Long.valueOf(journalId));
    }

    @Override
    public ProcResult fetchResult() throws AnalysisException {
        if (!Config.enable_bdbje_debug_mode) {
            throw new AnalysisException("Not in bdbje debug mode");
        }
        BaseProcResult result = new BaseProcResult();
        result.setNames((List<String>)TITLE_NAMES);
        BDBDebugger.BDBDebugEnv env = BDBDebugger.get().getEnv();
        try {
            List<Long> journalIds = env.getJournalIds(this.dbName);
            for (Long journalId : journalIds) {
                result.addRow(Lists.newArrayList((Object[])new String[]{journalId.toString()}));
            }
        }
        catch (BDBDebugger.BDBDebugException e) {
            throw new AnalysisException(e.getMessage());
        }
        return result;
    }
}

